/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.service.mapper;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.usage.accessor.model.PageWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.SpaceWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;

public class WorkflowsUsageTaskMapper {
    private final LongRunningTaskManager longRunningTaskManager;
    public static final String PAGE_TYPE = "page";
    public static final String SPACE_TYPE = "space";
    public static final String DOWNLOAD_URL = "/rest/cw/2/report/workflowsusage/csv?type=";

    public WorkflowsUsageTaskMapper(@ComponentImport LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public WorkflowsUsageTask fromPageWorkflowsRecordToModel(PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord) {
        WorkflowsUsageTask workflowsUsageTask = new WorkflowsUsageTask();
        if (pageWorkflowReportTaskRecord != null) {
            workflowsUsageTask.setStatus(pageWorkflowReportTaskRecord.getStatus());
            workflowsUsageTask.setStartedAt(pageWorkflowReportTaskRecord.getStartedAt());
            workflowsUsageTask.setDuration(pageWorkflowReportTaskRecord.getDuration());
            String taskId = pageWorkflowReportTaskRecord.getLongRunningTaskId();
            if (!Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus()) && taskId != null) {
                LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                if (longRunningTask != null) {
                    workflowsUsageTask.setProgress(longRunningTask.getPercentageComplete());
                }
            }
            if (Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus())) {
                workflowsUsageTask.setDownloadUrl("/rest/cw/2/report/workflowsusage/csv?type=page");
            }
        } else {
            workflowsUsageTask.setStatus(Status.NOT_RUN);
        }
        return workflowsUsageTask;
    }

    public WorkflowsUsageTask fromSpaceWorkflowsRecordToModel(SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord) {
        WorkflowsUsageTask workflowsUsageTask = new WorkflowsUsageTask();
        if (spaceWorkflowReportTaskRecord != null) {
            workflowsUsageTask.setStatus(spaceWorkflowReportTaskRecord.getStatus());
            workflowsUsageTask.setStartedAt(spaceWorkflowReportTaskRecord.getStartedAt());
            workflowsUsageTask.setDuration(spaceWorkflowReportTaskRecord.getDuration());
            String taskId = spaceWorkflowReportTaskRecord.getLongRunningTaskId();
            if (!Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus()) && taskId != null) {
                LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                if (longRunningTask != null) {
                    workflowsUsageTask.setProgress(longRunningTask.getPercentageComplete());
                }
            }
            if (Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus())) {
                workflowsUsageTask.setDownloadUrl("/rest/cw/2/report/workflowsusage/csv?type=space");
            }
        } else {
            workflowsUsageTask.setStatus(Status.NOT_RUN);
        }
        return workflowsUsageTask;
    }

    public PageWorkflowReportTaskRecord fromModelToPageWorkflowsRecord(WorkflowsUsageTask workflowsUsageTask) {
        PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord = new PageWorkflowReportTaskRecord();
        if (workflowsUsageTask != null) {
            pageWorkflowReportTaskRecord.setStatus(workflowsUsageTask.getStatus());
            pageWorkflowReportTaskRecord.setStartedAt(workflowsUsageTask.getStartedAt());
            pageWorkflowReportTaskRecord.setDuration(workflowsUsageTask.getDuration());
            pageWorkflowReportTaskRecord.setLongRunningTaskId(workflowsUsageTask.getLongRunningTaskId());
        }
        return pageWorkflowReportTaskRecord;
    }

    public SpaceWorkflowReportTaskRecord fromModelToSpaceWorkflowsRecord(WorkflowsUsageTask workflowsUsageTask) {
        SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord = new SpaceWorkflowReportTaskRecord();
        if (workflowsUsageTask != null) {
            spaceWorkflowReportTaskRecord.setStatus(workflowsUsageTask.getStatus());
            spaceWorkflowReportTaskRecord.setStartedAt(workflowsUsageTask.getStartedAt());
            spaceWorkflowReportTaskRecord.setDuration(workflowsUsageTask.getDuration());
            spaceWorkflowReportTaskRecord.setLongRunningTaskId(workflowsUsageTask.getLongRunningTaskId());
        }
        return spaceWorkflowReportTaskRecord;
    }
}

