/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.WorkflowsListener;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowsAppInstalledListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsAppInstalledListener.class);
    private final PluginAccessor pluginAccessor;

    public WorkflowsAppInstalledListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport PluginAccessor pluginAccessor) {
        super(eventPublisher);
        this.pluginAccessor = pluginAccessor;
    }

    @PluginEventListener
    public void handle(PluginModuleEnabledEvent event) {
        ArrayList<String> installedAppsKeys = new ArrayList<String>();
        try {
            if (this.pluginAccessor.isPluginEnabled("com.comalatech.workflow.approvals")) {
                installedAppsKeys.add("com.comalatech.workflow.approvals");
            }
            if (this.pluginAccessor.isPluginEnabled("com.comalatech.cloud.approvals")) {
                installedAppsKeys.add("com.comalatech.cloud.approvals");
            }
            if (this.pluginAccessor.isPluginEnabled("com.comalatech.workflow")) {
                installedAppsKeys.add("com.comalatech.workflow");
            }
            if (installedAppsKeys.size() > 1) {
                log.error("Multiple Comala Workflow Family products installed, disabling app '" + event.getModule().getPlugin().getKey() + "'");
                event.getModule().getPlugin().disable();
            }
        }
        catch (Exception e) {
            log.debug("An error happened while disabling the app '" + event.getModule().getPlugin().getKey() + "'", (Throwable)e);
        }
    }
}

