/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.workflow.InvalidWorkflow;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.rest.model.RestRemoteWorkflowsRepository;
import com.comalatech.confluence.workflowcontainer.SampleWorkflowStatusEnum;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public interface WorkflowContainerManager {
    public String loadSystemWorkflow(String var1) throws WorkflowException;

    public Workflow getSystemWorkflow(String var1) throws WorkflowException;

    public Workflow renderWorkflow(String var1) throws WorkflowException;

    public List<Workflow> getWorkflowTemplates(Space var1);

    public List<InvalidWorkflow> getInvalidWorkflowTemplates(Space var1);

    public List<Workflow> getAvailableWorkflowTemplates(Space var1);

    public RemoteWorkflowsRepository getRemoteWorkflows(boolean var1);

    public RestRemoteWorkflowsRepository getRestRemoteWorkflows(boolean var1, String var2, String var3);

    public Workflow getWorkflowTemplate(String var1, String var2) throws WorkflowException;

    public void saveWorkflowTemplate(String var1, Workflow var2, boolean var3, String var4);

    public void createWorkflowTemplateBackup(String var1, String var2, String var3);

    public Workflow restoreWorkflowBackup(@Nullable String var1, String var2) throws WorkflowException;

    public void removeWorkflowTemplate(String var1, String var2);

    public void copyWorkflowTemplate(String var1, Workflow var2);

    public void promoteWorkflowTemplate(String var1, Workflow var2);

    public boolean isGlobalWorkflowTemplateActive(String var1, String var2);

    public void setGlobalWorkflowActive(String var1, String var2, boolean var3);

    public boolean isSampleWorkflow(String var1);

    public boolean isWorkflowTemplateExists(String var1, String var2);

    public boolean isProductionWorkflowExists(String var1, String var2);

    public Workflow getProductionWorkflow(String var1, String var2) throws WorkflowException;

    public void promoteProductionWorkflow(String var1, Workflow var2);

    public void saveProductionWorkflow(String var1, Workflow var2, String var3);

    public void createProductionWorkflowBackup(String var1, String var2, String var3);

    public void removeProductionWorkflow(String var1, String var2);

    public void setActiveProductionWorkflow(String var1, Workflow var2, boolean var3);

    public List<Workflow> getCachedProductionWorkflows(AbstractPage var1, Label var2) throws WorkflowException;

    public boolean hasProductionWorkflows(AbstractPage var1);

    public boolean hasProductionWorkflows(Space var1);

    public List<Workflow> getAllProductionWorkflows(String var1);

    public int getCachedNumberOfProductionWorkflows();

    public void copyProductionWorkflow(String var1, Workflow var2);

    public String getDefaultApprovalWorkflowMarkup(String var1);

    public void registerSampleWorkflowsIfRequired();

    public ArrayList<String> getSampleWorkflowNames();

    public void setSampleWorkflowEnabled(Workflow var1);

    public void setSampleWorkflowDisabled(Workflow var1);

    public void setSampleWorkflowRemoved(Workflow var1);

    public SampleWorkflowStatusEnum getSampleWorkflowStatus(Workflow var1);

    public String getWorkflowMarkup(String var1);
}

