/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.accesor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Component;

@Component
public class WorkflowsActivityRecordAccessorImpl
implements WorkflowsActivityRecordAccessor {
    private static final String STATES_KEY = "states_key";
    private static final String READ_KEY = "read_key";
    private static final String SPACE_ID = "space_id";
    private static final String CONTENT_ID = "content_id";
    private static final String WORKFLOW_ACTIVITY_KEY = "com.comalatech.states";
    private static final String READ_ACK_ACTIVITY_KEY = "com.comalatech.readack.activities";
    private final EntityManagerProvider entityManagerProvider;
    private final DarkFeatureManager darkFeatureManager;

    public WorkflowsActivityRecordAccessorImpl(@ComponentImport EntityManagerProvider entityManagerProvider, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.entityManagerProvider = entityManagerProvider;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public List<WorkflowActivityRecord> findAllWorkflowActivity() {
        return this.findWorkflowActivity(null, null);
    }

    @Override
    public List<WorkflowActivityRecord> findWorkflowActivity(Integer start, Integer limit) {
        String sqlQuery = this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(false) != false ? "select content.space.id as SPACE_ID from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id is not null and content.originalVersion is null and (propertySet.key = :states_key or propertySet.key = :read_key) group by content.space.id " : "select count(distinct propertySet.entityId) as NUM_PAGES, content.space.id as SPACE_ID from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id is not null and content.originalVersion is null and (propertySet.key = :states_key or propertySet.key = :read_key) group by content.space.id order by NUM_PAGES desc";
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery(sqlQuery, Tuple.class);
        query.setParameter(STATES_KEY, (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter(READ_KEY, (Object)READ_ACK_ACTIVITY_KEY);
        if (this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.batches").orElse(false).booleanValue()) {
            query.setFirstResult(Objects.nonNull(start) && start > 0 ? start : 0);
            query.setMaxResults(Objects.nonNull(limit) && limit > 0 ? limit - start + 1 : 101);
        }
        List workflowActivityItems = query.getResultList();
        if (this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(false).booleanValue()) {
            return workflowActivityItems.stream().map(tuple -> new WorkflowActivityRecord(null, (Long)tuple.get("SPACE_ID"))).collect(Collectors.toList());
        }
        return workflowActivityItems.stream().map(tuple -> new WorkflowActivityRecord((Long)tuple.get("NUM_PAGES"), (Long)tuple.get("SPACE_ID"))).collect(Collectors.toList());
    }

    @Override
    public List<PageActivityRecord> findAllWorkflowActivityBySpace(Long spaceId) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select distinct propertySet.entityId as CONTENT_ID from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id = :space_id and (propertySet.key = :states_key or propertySet.key = :read_key) ", Tuple.class);
        query.setParameter(STATES_KEY, (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter(READ_KEY, (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter(SPACE_ID, (Object)spaceId);
        List pageWorkflowActivityItems = query.getResultList();
        return pageWorkflowActivityItems.stream().map(tuple -> new PageActivityRecord((Long)tuple.get("CONTENT_ID"), spaceId)).collect(Collectors.toList());
    }

    @Override
    public boolean hasWorkflowActivity(Long spaceId) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select propertySet.entityId from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id = :space_id and (propertySet.key = :states_key or propertySet.key = :read_key) ", Tuple.class);
        query.setParameter(STATES_KEY, (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter(READ_KEY, (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter(SPACE_ID, (Object)spaceId);
        query.setMaxResults(1);
        List results = query.getResultList();
        return results != null && !results.isEmpty();
    }

    @Override
    public boolean hasWorkflowActivity(AbstractPage content) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select propertySet.entityId from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.id = :content_id and (propertySet.key = :states_key or propertySet.key = :read_key) ", Tuple.class);
        query.setParameter(STATES_KEY, (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter(READ_KEY, (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter(CONTENT_ID, (Object)content.getId());
        query.setMaxResults(1);
        List results = query.getResultList();
        return !results.isEmpty();
    }
}

