/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.macro;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class TaskMacro
extends AbstractWorkflowElementMacro {
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Parameters params = new Parameters(parameters, renderContext);
        List<WorkflowElement> elements = this.getElementsList(renderContext);
        Task task = new Task(params.name, params.type, params.assignee, params.note);
        task.setDueDate(params.dueDate);
        elements.add(task);
        return "";
    }

    @Override
    public boolean allowsAnonymousUser() {
        return false;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    private class Parameters
    extends MacroParameters {
        String name;
        TaskType type;
        String assignee;
        String note;
        String dueDate;

        public Parameters(Map parameters, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            this.name = this.get(new String[]{"name", "0"}, true);
            if (!Task.isValidTaskName(this.name)) {
                throw new MacroException("Invalid task name '" + this.name + "'");
            }
            this.assignee = this.get(new String[]{"assignee", "user", "assigned"});
            String type = this.get("type");
            this.type = TaskType.parse(type);
            if (this.type == null) {
                this.type = TaskType.DEFAULT;
            }
            this.note = MapUtils.getString(parameters, "note");
            this.dueDate = this.get(new String[]{"duedate", "dueDate"});
        }
    }
}

