/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.event.page;

import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;

public class PageStateTransitionEvent
extends PageEvent
implements StateTransitionEvent {
    private final PageState oldState;
    private final PageState newState;
    private transient boolean initial;
    private String sourceEvent = "statechanged";

    public PageStateTransitionEvent(Object src, Page page, PageState oldState, PageState newState) {
        super(src, page);
        this.oldState = oldState;
        this.newState = newState;
    }

    @Override
    public PageState getPreviousEvent() {
        return this.oldState;
    }

    @Override
    public PageState getState() {
        return this.newState;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public String getSourceEvent() {
        return this.sourceEvent;
    }

    public void setSourceEvent(String sourceEvent) {
        this.sourceEvent = sourceEvent;
    }

    public String toString() {
        if (this.newState == null || this.getContent() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(TimerUtils.logDate(this.newState.getDate())).append(" ").append(this.getContent());
        if (this.oldState != null) {
            sb.append(" changed from ").append(this.oldState.getState()).append(" to ").append(this.newState.getState());
        } else {
            sb.append(" changed to ").append(this.newState.getState());
        }
        sb.append(" ").append(Activity.toString(this.newState));
        return sb.toString();
    }
}

