/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivityApprovals;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivityReadAcks;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivityStates;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivityTasks;
import com.comalatech.confluence.readack.activity.ReadAckActivityManager;
import com.comalatech.confluence.readack.activity.ReadAckActivityModel;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GenerateDocumentActivityUseCase
implements GenerateDocumentActivity {
    private static final Logger log = LoggerFactory.getLogger(GenerateDocumentActivityUseCase.class);
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final WorkflowAccessor workflowAccessor;
    private final ReadAckActivityManager readAckActivityManager;
    private final GenerateDocumentActivityTasks documentActivityTasks;
    private final GenerateDocumentActivityApprovals documentActivityApprovals;
    private final GenerateDocumentActivityReadAcks documentActivityReadConfirmations;
    private final GenerateDocumentActivityStates documentActivityStates;

    public GenerateDocumentActivityUseCase(WorkflowAccessor workflowAccessor, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, ReadAckActivityManager readAckActivityManager, GenerateDocumentActivityTasks documentActivityTasks, GenerateDocumentActivityApprovals documentActivityApprovals, GenerateDocumentActivityReadAcks documentActivityReadConfirmations, GenerateDocumentActivityStates documentActivityStates) {
        this.workflowAccessor = workflowAccessor;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.readAckActivityManager = readAckActivityManager;
        this.documentActivityTasks = documentActivityTasks;
        this.documentActivityApprovals = documentActivityApprovals;
        this.documentActivityReadConfirmations = documentActivityReadConfirmations;
        this.documentActivityStates = documentActivityStates;
    }

    @Override
    public List<Activity> generate(AbstractPage page) throws Exception {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        if (page == null) {
            return activities;
        }
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        List<PageState> states = this.stateAccessor.getPageStates(page);
        if (this.hasDuplicates(states)) {
            throw new Exception("Page " + page.getId() + " has duplicate states");
        }
        LinkedList<ApprovalCheck> approvalChecks = new LinkedList<ApprovalCheck>(Arrays.asList(this.approvalAccessor.getApprovalChecks(page)));
        List<ReadAckActivityModel> readAcks = this.readAckActivityManager.getReadAckActivities(page);
        if (!readAcks.isEmpty()) {
            activities.addAll(this.documentActivityReadConfirmations.generate(page, readAcks));
        }
        for (int i = 0; i < states.size(); ++i) {
            boolean hideState;
            PageState state = states.get(i);
            boolean bl = hideState = pageWorkflows != null && pageWorkflows.isHidStates();
            if (!this.nextStateHasChangeReason(i, states) && !hideState) {
                PageState previousState = this.getPreviousState(i, states);
                activities.addAll(this.documentActivityStates.generate(state, previousState));
            }
            PageTasks pageTasks = state.getPageTasks();
            List<Integer> approvalsToIgnore = new ArrayList<Integer>();
            if (pageTasks != null) {
                List<PageTask> tasks;
                if (pageTasks.getTasks() != null && !pageTasks.getTasks().isEmpty()) {
                    tasks = pageTasks.getTasks();
                    approvalsToIgnore = this.getTasksCompletedApprovals(tasks);
                    activities.addAll(this.documentActivityTasks.generate(state, tasks));
                }
                if (pageTasks.getDeletedTasks() != null && !pageTasks.getDeletedTasks().isEmpty()) {
                    tasks = pageTasks.getDeletedTasks();
                    activities.addAll(this.documentActivityTasks.generate(state, tasks));
                }
            }
            this.removeTasksApprovals(approvalChecks, approvalsToIgnore);
            List<ApprovalCheck> stateApprovals = approvalChecks.stream().filter(approvalCheck -> approvalCheck.getStateId() == state.getId()).collect(Collectors.toList());
            if (stateApprovals.isEmpty()) continue;
            activities.addAll(this.documentActivityApprovals.generate(state, stateApprovals));
        }
        activities.sort(new ActivityComparator());
        this.addStateIdForReadConfirmations(activities);
        List<Activity> result = this.groupActivitiesByState(activities);
        Collections.reverse(result);
        return result;
    }

    private void addStateIdForReadConfirmations(List<Activity> activities) {
        Integer stateId = -1;
        for (Activity activity : activities) {
            if (activity.getState() != null && !ActionType.Subtype.STATE_CLOSED.equals((Object)activity.getAction().getActionType().getSubtype())) {
                stateId = activity.getState();
                continue;
            }
            activity.getAction().getActionDetails().addDetail(ActionDetailType.STATE_ID, String.valueOf(stateId));
        }
    }

    private List<Activity> groupActivitiesByState(List<Activity> activities) {
        LinkedHashMap groupByState = activities.stream().filter(act -> act.getAction().getActionDetails().getDetailValue(ActionDetailType.STATE_ID) != null).collect(Collectors.groupingBy(Activity::getState, LinkedHashMap::new, Collectors.toList()));
        return groupByState.entrySet().stream().flatMap(elem -> ((List)elem.getValue()).stream()).collect(Collectors.toList());
    }

    private boolean nextStateHasChangeReason(int index, List<PageState> states) {
        if (index == states.size() - 1) {
            return false;
        }
        return this.stateHasChangeReason(index + 1, states);
    }

    private boolean stateHasChangeReason(int index, List<PageState> states) {
        PageState previousState = states.get(index - 1);
        PageState actualState = states.get(index);
        return actualState.getStateChangeReason() != null && previousState.equalsIgnoreChangeReason(actualState);
    }

    private PageState getPreviousState(int index, List<PageState> states) {
        PageState previousState = null;
        if (index > 1 && this.stateHasChangeReason(index, states)) {
            previousState = states.get(index - 2);
        } else if (index > 0) {
            previousState = states.get(index - 1);
        }
        return previousState;
    }

    private List<Integer> getTasksCompletedApprovals(List<PageTask> tasks) {
        ArrayList<Integer> approvalsIds = new ArrayList<Integer>();
        if (tasks == null || tasks.isEmpty()) {
            return approvalsIds;
        }
        tasks.forEach(task -> {
            List<TaskCompletion> completions = task.getCompletions();
            if (completions != null && !completions.isEmpty()) {
                completions.forEach(completed -> {
                    if (completed.getApprovalCheckId() != 0) {
                        approvalsIds.add(completed.getApprovalCheckId());
                    }
                });
            }
        });
        return approvalsIds;
    }

    private void removeTasksApprovals(List<ApprovalCheck> approvalChecks, List<Integer> approvalsToIgnore) {
        approvalChecks.removeIf(approvalCheck -> approvalsToIgnore.contains(approvalCheck.getId()));
    }

    private boolean hasDuplicates(List<PageState> states) {
        HashSet<Integer> seen = new HashSet<Integer>();
        for (PageState state : states) {
            if (seen.add(state.getId())) continue;
            return true;
        }
        return false;
    }

    private static class ActivityComparator
    implements Comparator<Activity> {
        private static final String ANONYMOUS_USER = "anonymous";

        private ActivityComparator() {
        }

        @Override
        public int compare(Activity firstActivity, Activity secondActivity) {
            String secondActorName;
            if (firstActivity.getMoment() != secondActivity.getMoment()) {
                return Long.compare(firstActivity.getMoment(), secondActivity.getMoment());
            }
            String firstActorName = firstActivity.getAction().getActors().get(0).getName();
            if (!firstActorName.equals(secondActorName = secondActivity.getAction().getActors().get(0).getName())) {
                if (ActivityComparator.isAnonymousUser(firstActorName) && !ActivityComparator.isAnonymousUser(secondActorName)) {
                    return -1;
                }
                if (!ActivityComparator.isAnonymousUser(firstActorName) && ActivityComparator.isAnonymousUser(secondActorName)) {
                    return 1;
                }
                return StringUtils.compare((String)firstActorName, (String)secondActorName);
            }
            if (firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_CREATION) && (secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_ASSIGNMENT) || secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_UNASSIGNMENT))) {
                return -1;
            }
            if ((firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_ASSIGNMENT) || firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_UNASSIGNMENT)) && secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_CREATION)) {
                return 1;
            }
            if ((firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_ASSIGNMENT) || firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_UNASSIGNMENT)) && secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_DUE_DATE)) {
                return -1;
            }
            if (firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_DUE_DATE) && (secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_ASSIGNMENT) || secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_UNASSIGNMENT))) {
                return 1;
            }
            if (firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_DUE_DATE_DELETED) && (secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_ASSIGNMENT) || secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_UNASSIGNMENT))) {
                return 1;
            }
            if ((firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_ASSIGNMENT) || firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_UNASSIGNMENT)) && secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.TASK_DUE_DATE_DELETED)) {
                return -1;
            }
            if ((firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.APPROVAL_UNASSIGNED) || firstActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.APPROVAL_ASSIGNED)) && secondActivity.getAction().getActionType().getSubtype().equals((Object)ActionType.Subtype.STATE_EXPIRY_UPDATE)) {
                return -1;
            }
            return 0;
        }

        private static boolean isWorkflowUser(String firstActorName, String secondActorName) {
            return "com.comalatech.workflow".equals(firstActorName) || "com.comalatech.workflow".equals(secondActorName);
        }

        private static boolean isAnonymousUser(String actorName) {
            return "com.comalatech.anonymous".equals(actorName);
        }
    }
}

