/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class CloudMappingsDataRetrievalUseCase
implements CloudMappingsData {
    @Override
    public Map<String, String> getCloudMappings(AppCloudMigrationGateway gateway, String transferId, String namespace) {
        PaginatedMapping userMapping = gateway.getPaginatedMapping(transferId, namespace, 5000);
        userMapping.next();
        return userMapping.getMapping();
    }

    @Override
    public Map<String, String> getCloudMappings(AppCloudMigrationGateway gateway, String transferId, String namespace, Set<String> mappingIds) {
        int MAX_SIZE = 99;
        HashSet<String> batch = new HashSet<String>(99);
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String id : mappingIds) {
            batch.add(id);
            if (batch.size() != 99) continue;
            mappings.putAll(gateway.getMappingById(transferId, namespace, batch));
            batch = new HashSet(99);
        }
        if (!batch.isEmpty()) {
            mappings.putAll(gateway.getMappingById(transferId, namespace, batch));
        }
        return mappings;
    }
}

