/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.cloud.migration.accessor.CloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.ExportMetadataRecord;
import com.comalatech.confluence.cloud.migration.entity.MigrationTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.MigrationTaskStatus;
import com.comalatech.confluence.cloud.migration.service.CloudMigrationContentService;
import com.comalatech.confluence.cloud.migration.utils.MigrationPackageFile;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.accesor.ContentRestrictionWorkflowRecordAccessor;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.ContentActivityCSVWorkflowRecord;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.CompressionUtils;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvServiceImpl;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultCloudMigrationContentService
implements CloudMigrationContentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudMigrationContentService.class);
    private final WorkflowsActivityRecordAccessor workflowsActivityRecordAccessor;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final CloudMigrationAccessor attachActivityAccessor;
    private final CloudMigrationAccessor exportMetadataAccessor;
    private final ActivityManager activityManager;
    private final AttachmentManager attachmentManager;
    private final PageActivityCsvServiceImpl pageActivityCsvService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final WorkflowContainerManager workflowContainerManager;
    private final StateService stateService;
    private final ContentRestrictionWorkflowRecordAccessor contentRestrictionWorkflowRecordAccessor;

    public DefaultCloudMigrationContentService(WorkflowsActivityRecordAccessor workflowsActivityRecordAccessor, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @Qualifier(value="attachActivityAccessor") CloudMigrationAccessor attachActivityAccessor, @Qualifier(value="exportMetadataAccessor") CloudMigrationAccessor exportMetadataAccessor, ActivityManager activityManager, @ComponentImport AttachmentManager attachmentManager, PageActivityCsvServiceImpl pageActivityCsvService, ContentRestrictionWorkflowRecordAccessor contentRestrictionWorkflowRecordAccessor, ReadWriteTransactionService readWriteTransactionService, AdhocWorkflowManager adhocWorkflowManager, WorkflowContainerManager workflowContainerManager, StateService stateService) {
        this.workflowsActivityRecordAccessor = workflowsActivityRecordAccessor;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.attachActivityAccessor = attachActivityAccessor;
        this.exportMetadataAccessor = exportMetadataAccessor;
        this.activityManager = activityManager;
        this.attachmentManager = attachmentManager;
        this.pageActivityCsvService = pageActivityCsvService;
        this.contentRestrictionWorkflowRecordAccessor = contentRestrictionWorkflowRecordAccessor;
        this.readWriteTransactionService = readWriteTransactionService;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowContainerManager = workflowContainerManager;
        this.stateService = stateService;
    }

    @NotNull
    private static String getPageActivityFileName(AbstractPage page) {
        SimpleDateFormat dateFormatterForFileName = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        return "page_activity_" + page.getId() + "_" + dateFormatterForFileName.format(new Date()) + "_" + RandomStringUtils.random((int)8, (boolean)true, (boolean)false) + ".csv";
    }

    @NotNull
    private static String getSpaceActivityZipName(AbstractPage homePage) {
        SimpleDateFormat dateFormatterForFileName = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        return homePage.getSpaceKey() + "_activity_" + dateFormatterForFileName.format(new Date()) + "_" + RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
    }

    @Override
    public List<Long> getPagesWithWorkflow(Long spaceId) {
        List<PageActivityRecord> records = this.workflowsActivityRecordAccessor.findAllWorkflowActivityBySpace(spaceId);
        return records.stream().map(pageActivityRecord -> this.pageManager.getAbstractPage(pageActivityRecord.getPageId().longValue())).filter(this::hasWorkflowActive).map(EntityObject::getId).collect(Collectors.toList());
    }

    @Override
    public List<ContentActivityCSVWorkflowRecord> getSpacesWithNoCSVAttachments(List<String> spaceKeys) {
        return this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
            ArrayList records = new ArrayList();
            spaceKeys.forEach(spaceKey -> {
                Space space;
                AttachActivityTaskRecord activityTaskRecordPerPage = this.getAttachActivityTaskStatus((String)spaceKey, false);
                AttachActivityTaskRecord activityTaskRecordPerSpace = this.getAttachActivityTaskStatus((String)spaceKey, true);
                List<MigrationTaskRecord> status = Arrays.asList(activityTaskRecordPerPage, activityTaskRecordPerSpace);
                status.sort((o1, o2) -> {
                    if (o1.getStartedTimestamp() == null && o2.getStartedTimestamp() == null) {
                        return 0;
                    }
                    if (o1.getStartedTimestamp() == null) {
                        return -1;
                    }
                    if (o2.getStartedTimestamp() == null) {
                        return 1;
                    }
                    return o1.getStartedTimestamp().compareTo(o2.getStartedTimestamp());
                });
                if (!status.stream().map(MigrationTaskRecord::getStatus).collect(Collectors.toList()).contains((Object)MigrationTaskStatus.COMPLETED) && (space = this.spaceManager.getSpace(spaceKey)) != null) {
                    records.add(new ContentActivityCSVWorkflowRecord((String)spaceKey, space.getName(), status.get(1).getStatus()));
                }
            });
            return records;
        });
    }

    @Override
    public AttachActivityTaskRecord getAttachActivityTaskStatus(String spaceKey, boolean isPerSpace) {
        return (AttachActivityTaskRecord)this.attachActivityAccessor.getMigrationTaskStatus(spaceKey, isPerSpace);
    }

    @Override
    public void setAttachActivityTaskStatus(String spaceKey, AttachActivityTaskRecord status, boolean isPerSpace) {
        this.attachActivityAccessor.setMigrationTaskStatus(spaceKey, status, isPerSpace);
    }

    @Override
    public ExportMetadataRecord getExportMetadataTaskStatus(String spaceKey) {
        return (ExportMetadataRecord)this.exportMetadataAccessor.getMigrationTaskStatus(spaceKey, true);
    }

    @Override
    public void setExportMetadataTaskStatus(String spaceKey, ExportMetadataRecord status) {
        this.exportMetadataAccessor.setMigrationTaskStatus(spaceKey, status, true);
    }

    @Override
    public void attachCsvToPage(long pageId) {
        try {
            String csv = this.getPageCsv(pageId);
            this.addCsvAsAttachmentToPage(pageId, csv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> getContentWithRestrictions(List<String> spaceIdList) {
        return this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
            ArrayList<ContentRestrictionWorkflowRecord> contentRestrictionWorkflowRecordList = new ArrayList<ContentRestrictionWorkflowRecord>();
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentRestrictionSpaceWorkflows(spaceIdList));
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentRestrictionWorkflows(spaceIdList));
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentInheritedRestrictionSpaceWorkflows(spaceIdList));
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentInheritedRestrictionWorkflows(spaceIdList));
            return contentRestrictionWorkflowRecordList;
        });
    }

    @Override
    public String getPageCsv(Long pageId) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport(page, exportOptions);
        return this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, page, PageActivityCsvConfig.builder().skipOtherVersion(false).build());
    }

    @Override
    public void attachZipToHomePage(String spaceKey, HashMap<Long, String> pageActivityCsvList) throws IOException {
        Space space = this.spaceManager.getSpace(spaceKey);
        Page homePage = space.getHomePage();
        String folderName = DefaultCloudMigrationContentService.getSpaceActivityZipName((AbstractPage)homePage);
        Path basePath = this.generateBaseFolder(folderName);
        pageActivityCsvList.forEach((pageId, csvString) -> {
            AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
            if (page != null) {
                String fileName = StringUtils.deleteWhitespace((String)MigrationPackageFile.makeSafe(page.getTitle() + "_" + page.getIdAsString() + ".csv"));
                try {
                    this.basicGenerateSupportFile(basePath, (String)csvString, fileName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                log.error("Page with id {} does not exist", pageId);
            }
        });
        Path zipPath = this.generateZipPath(basePath.getParent(), folderName);
        CompressionUtils.compressToZip(basePath, zipPath);
        Attachment attachment = new Attachment(folderName + ".zip", "application/octet-stream", zipPath.toFile().length(), "");
        attachment.setCreator(AuthenticatedUserThreadLocal.get());
        attachment.setCreationDate(new Date());
        attachment.setLastModificationDate(new Date());
        attachment.setContainer((ContentEntityObject)homePage);
        this.attachmentManager.saveAttachment(attachment, null, Files.newInputStream(zipPath, new OpenOption[0]));
        homePage.addAttachment(attachment);
    }

    private void addCsvAsAttachmentToPage(Long pageId, String csv) throws IOException {
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        String fileName = DefaultCloudMigrationContentService.getPageActivityFileName(page);
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Attachment attachment = new Attachment(fileName, "text/csv", (long)csv.getBytes().length, "");
        attachment.setCreator(confluenceUser);
        attachment.setCreationDate(new Date());
        attachment.setLastModificationDate(new Date());
        attachment.setContainer((ContentEntityObject)page);
        this.attachmentManager.saveAttachment(attachment, null, (InputStream)new ByteArrayInputStream(csv.getBytes()));
        page.addAttachment(attachment);
    }

    private boolean hasWorkflowActive(AbstractPage page) {
        if (Objects.isNull(page)) {
            return false;
        }
        log.debug("Checking if page {} has active workflow...", (Object)page.getId());
        boolean hasPageWorkflow = this.adhocWorkflowManager.hasWorkflow(page);
        boolean hasSpaceWorkflow = this.workflowContainerManager.hasProductionWorkflows(page);
        State currentState = this.stateService.getCurrentState((ContentEntityObject)page);
        log.debug("Has page workflow {}, has space workflow {}, current state {}", new Object[]{hasPageWorkflow, hasSpaceWorkflow, currentState != null ? currentState.getName() : null});
        return hasSpaceWorkflow && currentState != null || hasPageWorkflow;
    }

    private Path generateZipPath(Path temporaryFolder, String name) throws IOException {
        Path zipFilePath = Paths.get(temporaryFolder.toString(), name + ".zip");
        return Files.createFile(zipFilePath, new FileAttribute[0]);
    }

    private Path generateBaseFolder(String name) throws IOException {
        Path basePath = Files.createTempDirectory("migrationActivityFolder", new FileAttribute[0]);
        Path temp = basePath.getParent();
        Path tempFolder = Paths.get(temp.toString(), name);
        return Files.move(basePath, tempFolder, new CopyOption[0]);
    }

    private void basicGenerateSupportFile(Path baseFolder, String csv, String filename) throws IOException {
        Path globalConfigFilePath = Paths.get(baseFolder.toString(), filename);
        this.basicWriteFile(globalConfigFilePath, csv);
    }

    private void basicWriteFile(Path path, String csv) throws IOException {
        Files.deleteIfExists(path);
        Path filePath = Files.createFile(path, new FileAttribute[0]);
        Files.write(filePath, csv.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

