/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var CW = CW || {};
AJS.toInit(function ($) {
    
    if (CW && !_.isEmpty(CW)) {
        $('body').addClass('aui'+CW.getAUIVersion())
    };

    AJS.$(".cw-filter").on('click', function() {
        var $target = AJS.$(this);
        var enabled = !$target.attr('aria-pressed');

        // update button
        $target.toggleClass('cw-enabled', enabled);
        $target.attr('aria-pressed', enabled);
        $("#cw-filterSpinner").spin();
    });

    $(".cw-order").on('click', function() {
        var $target = AJS.$(this);
        var enabled = !$target.attr('aria-pressed');

        // update button
        $target.toggleClass('cw-enabled', enabled);
        $target.attr('aria-pressed', enabled);
        $("#cw-filterSpinner").spin();
    });
});
