/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.supplier;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.supplier.AbstractConfluenceSupplier;
import org.randombits.confluence.supplier.LinkableSupplier;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;
import org.randombits.confluence.support.LinkAssistant;
import org.randombits.storage.ResourceStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntitySupplier<T extends ConfluenceEntityObject>
extends AbstractConfluenceSupplier
implements LinkableSupplier {
    private static final String ID_KEY = "id";
    private static final String TYPE_KEY = "type";
    private static final String TITLE_KEY = "title";
    private static final String URL_KEY = "url";
    private static final String ICON_KEY = "icon";
    private static final String CREATOR_KEY = "creator";
    private static final String CREATION_DATE_KEY = "creation date";
    private static final String MODIFIER_KEY = "modifier";
    private static final String MODIFICATION_DATE_KEY = "modification date";
    private static final String VERSION_KEY = "version";
    private static final String IS_LATEST_VERSION_KEY = "is latest version";
    private static final String LATEST_VERSION_KEY = "latest version";
    private static final String EQUALS_PREFIX = "equals ";
    private static final String SELF = "@self";
    private static final String PARENT = "@parent";
    private ResourceStorage resources;
    private LinkManager linkManager;
    private LinkResolver linkResolver;
    private Class<T> type;

    public AbstractEntitySupplier(Class<T> type) {
        this.type = type;
    }

    protected Class<T> getType() {
        return this.type;
    }

    @Override
    public Object getValue(Object context, String key) throws UnsupportedContextException, SupplierException {
        if (this.type.isInstance(context)) {
            ConfluenceEntityObject entity = (ConfluenceEntityObject)this.type.cast(context);
            return this.getValue((T)entity, key);
        }
        throw new UnsupportedContextException(context);
    }

    protected Object getValue(T entity, String key) throws SupplierException {
        if (key == null || TITLE_KEY.equals(key)) {
            return this.getTitle(entity);
        }
        if (ID_KEY.equals(key)) {
            return new Long(entity.getId());
        }
        if (TYPE_KEY.equals(key)) {
            return this.getType(entity);
        }
        if (URL_KEY.equals(key)) {
            return this.getUrl(entity);
        }
        if (key.startsWith(EQUALS_PREFIX)) {
            return AbstractEntitySupplier.equalsKey(entity, key.substring(EQUALS_PREFIX.length()));
        }
        if (CREATOR_KEY.equals(key)) {
            return this.getUser(entity.getCreatorName());
        }
        if (CREATION_DATE_KEY.equals(key)) {
            return entity.getCreationDate();
        }
        if (MODIFIER_KEY.equals(key)) {
            return this.getUser(entity.getLastModifierName());
        }
        if (MODIFICATION_DATE_KEY.equals(key)) {
            return entity.getLastModificationDate();
        }
        if (ICON_KEY.equals(key)) {
            return this.getIconURL(entity);
        }
        if (entity instanceof Versioned) {
            Versioned versioned = (Versioned)entity;
            if (VERSION_KEY.equals(key)) {
                return new Integer(versioned.getVersion());
            }
            if (IS_LATEST_VERSION_KEY.equals(key)) {
                return versioned.isLatestVersion();
            }
            if (LATEST_VERSION_KEY.equals(key)) {
                return versioned.getLatestVersion();
            }
        }
        return null;
    }

    protected abstract String getIconURL(T var1);

    protected abstract String getUrl(T var1);

    protected abstract String getTitle(T var1);

    protected abstract String getType(T var1);

    @Override
    public boolean supportsContext(Object context) {
        return this.type.isInstance(context);
    }

    @Override
    public String getLink(Object context) throws UnsupportedContextException, SupplierException {
        if (this.type.isInstance(context)) {
            ConfluenceEntityObject entity = (ConfluenceEntityObject)this.type.cast(context);
            return this.getUrl(entity);
        }
        throw new UnsupportedContextException(context);
    }

    private static Boolean equalsKey(ConfluenceEntityObject entity, String key) {
        try {
            PageContext ctx = ReportBuilder.getCurrentPageContext();
            key = key.trim();
            if (ctx != null) {
                ContentEntityObject target = ctx.getEntity();
                if (SELF.equals(key)) {
                    return new Boolean(entity.equals((Object)target));
                }
                if (PARENT.equals(key) && target instanceof Page) {
                    return new Boolean(entity.equals((Object)((Page)target).getParent()));
                }
                target = LinkAssistant.getInstance().getLinkedEntity(ctx, key);
                return new Boolean(entity.equals((Object)target));
            }
            return Boolean.FALSE;
        }
        catch (ReportException e) {
            return Boolean.FALSE;
        }
    }

    private Object getUser(String username) {
        User user;
        if (username != null && (user = this.getUserAccessor().getUser(username)) != null) {
            return user;
        }
        return username;
    }

    protected String getText(String key, String def) {
        if (this.resources == null) {
            this.resources = new ResourceStorage(this.getClass());
        }
        return this.resources.getString(key, def);
    }

    protected LinkManager getLinkManager() {
        if (this.linkManager == null) {
            this.linkManager = (LinkManager)ContainerManager.getComponent((String)"linkManager");
        }
        return this.linkManager;
    }

    protected LinkResolver getLinkResolver() {
        if (this.linkResolver == null) {
            this.linkResolver = (LinkResolver)ContainerManager.getComponent((String)"linkResolver");
        }
        return this.linkResolver;
    }
}

