/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflowreports.macro.BaseWorkflowReportMacro;
import com.comalatech.confluence.workflowreports.macro.parameter.StateMacroParameters;
import com.comalatech.confluence.workflowreports.manager.state.WorkflowStateReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowStateReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowReportFilters;
import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowStateReportFiltersJsonPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowStateReportOptionsCqlPresenter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class WorkflowStateReportMacro
extends BaseWorkflowReportMacro {
    private static final String STATES_TEMPLATE = "/templates/reports/macros/states-report-macro.vm";
    private static final String EXPORT_STATES_TEMPLATE = "/templates/reports/macros/export-states-report-macro.vm";
    public static final int EXPORT_MAX_COLUMN_NUMBER = 12;
    public static final int LANDSCAPE_EXPORT_MAX_ENTRIES = 11;
    protected StateMacroParameters options;
    private WorkflowStateReportManager workflowStateReportManager;

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new StateMacroParameters(parameters, renderContext, this.workflowsFeatureManager, this.userAccessor, this.pageManager);
        WorkflowStatesReportOptions statesReportOptions = this.options.getWorkflowStatesReportOptions();
        WorkflowReportFilters statesReportFilters = this.buildReportFilters(this.options.getWorkflowStatesReportOptions());
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(new WorkflowStateReportOptionsCqlPresenter(statesReportOptions, this.objectMapper).present());
        contextMap.putAll(new WorkflowStateReportFiltersJsonPresenter(statesReportFilters, this.objectMapper).present());
        contextMap.put("currentSpaceKey", this.getCurrentSpaceKey(renderContext));
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        contextMap.put("isPreview", "preview".equals(renderContext.getOutputType()));
        if (Boolean.parseBoolean((String)renderContext.getParam((Object)"send-email"))) {
            renderContext.setOutputType("email");
        }
        switch (renderContext.getOutputType()) {
            case "preview": 
            case "display": {
                return this.renderTemplate(contextMap, STATES_TEMPLATE);
            }
            case "word": 
            case "pdf": 
            case "html_export": 
            case "email": {
                return this.renderExportStatesReportTemplate(statesReportOptions, contextMap);
            }
        }
        return null;
    }

    private String renderExportStatesReportTemplate(WorkflowStatesReportOptions options, Map<String, Object> contextMap) throws MacroException {
        HashMap<String, Object> renderMap = new HashMap<String, Object>();
        List columnsToShow = Stream.of(options.getColumnsToShow().split(",", -1)).map(column -> column.replace(" ", "")).collect(Collectors.toList());
        columnsToShow.removeIf(column -> column.equals("approvals") || column.equals("approvalstatus"));
        List<ExportWorkflowStateReportEntry> reportEntries = this.workflowStateReportManager.createReport(options, contextMap);
        renderMap.put("exportReport", columnsToShow.size() > 12 ? this.chunkList(reportEntries, 11) : reportEntries);
        renderMap.put("columnsToShow", columnsToShow);
        renderMap.put("verticalLayoutMaxColumnNumber", 12);
        return this.renderTemplate(renderMap, EXPORT_STATES_TEMPLATE);
    }

    private List<List<ExportWorkflowStateReportEntry>> chunkList(List<ExportWorkflowStateReportEntry> originalList, int chunkSize) {
        return IntStream.range(0, (originalList.size() + chunkSize - 1) / chunkSize).mapToObj(i -> originalList.subList(i * chunkSize, Math.min((i + 1) * chunkSize, originalList.size()))).collect(Collectors.toList());
    }

    public void setWorkflowStateReportManager(WorkflowStateReportManager workflowStateReportManager) {
        this.workflowStateReportManager = workflowStateReportManager;
    }
}

