/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.workflow.StateService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetStateExpiryDateMacro
extends AbstractActionMacro {
    private static final Logger log = LoggerFactory.getLogger(SetStateExpiryDateMacro.class);
    protected static final String PARAM_DUE_DATE = "duedate";
    private StateService stateService;

    public String execute(Map parameters, String arg1, RenderContext renderContext) throws MacroException {
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        List<AbstractPage> pages = this.getPagesFromParams(parameters, renderContext);
        String dueDateString = MapUtils.getString(parameters, PARAM_DUE_DATE);
        Date expiryDate = null;
        if (StringUtils.isNotBlank((CharSequence)dueDateString)) {
            ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
            if (valueStore != null) {
                dueDateString = valueStore.replaceReferences(dueDateString);
            }
            Period dueDatePeriod = TimerUtils.parsePeriod(dueDateString);
            DateTime dateTime = DateTime.now();
            expiryDate = dateTime.plus(dueDatePeriod).toDate();
        }
        if (log.isDebugEnabled()) {
            log.debug("Updating expiry date to: {} for pages: {}", expiryDate, pages);
        }
        for (AbstractPage page : pages) {
            this.stateService.updateExpiryDate((ContentEntityObject)page, expiryDate, false);
        }
        return "";
    }

    @Override
    protected String getName() {
        return "set-state-expiry";
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }
}

