/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.filters;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreventVersionDeleteFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PreventVersionDeleteFilter.class);
    private final PageManager pageManager;
    private final WorkflowAccessor workflowAccessor;

    public PreventVersionDeleteFilter(PageManager pageManager, WorkflowAccessor workflowAccessor) {
        this.pageManager = pageManager;
        this.workflowAccessor = workflowAccessor;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AbstractPage currentVersion;
        AbstractPage historicalVersion;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String pageIdString = req.getParameter("pageId");
        if (StringUtils.isNotBlank((CharSequence)pageIdString) && (historicalVersion = this.pageManager.getAbstractPage(Long.parseLong(pageIdString))) != null && (currentVersion = historicalVersion.getLatestVersion()) != null && this.workflowAccessor.hasWorkflowsOrApprovals((ContentEntityObject)currentVersion, false)) {
            log.info("Preventing deletion of historic page: " + historicalVersion + " by user: " + AuthenticatedUserThreadLocal.getUsername() + " because page has a workflow");
            resp.sendError(400, "Cannot remove page version as page is subject to a workflow");
        }
        if (!resp.isCommitted()) {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

