/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.webresource.compat;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.sal.api.component.ComponentLocator;
import com.comalatech.confluence.util.MemoizedSupplier;
import com.comalatech.confluence.webresource.compat.WebResourceManagerCompat;
import com.comalatech.confluence.webresource.compat.WebResourceManagerConf8;
import com.comalatech.confluence.webresource.compat.WebResourceManagerConf9;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultWebResourceManagerCompat
implements WebResourceManagerCompat {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceManagerCompat.class);
    private final Supplier<WebResourceManagerCompat> delegate = new MemoizedSupplier<WebResourceManagerCompat>(() -> this.initialiseWebResourceCompat(DefaultWebResourceManagerCompat.class.getClassLoader()));

    @Autowired
    public DefaultWebResourceManagerCompat() {
    }

    private WebResourceManagerCompat initialiseWebResourceCompat(ClassLoader classLoader) {
        WebResourceManagerCompat internalDelegate;
        try {
            Object webResourceManager = this.getConfluenceWebResourceConf9(classLoader);
            internalDelegate = new WebResourceManagerConf9(webResourceManager);
        }
        catch (ClassNotFoundException var6) {
            log.debug("Could not find WebResourceManager Conf 9, falling back to Confluence 8.5.14 or prior WebResourceManager impl.", (Throwable)var6);
            try {
                Object pluginXStream = this.getConfluenceWebResourceConf8(classLoader);
                internalDelegate = new WebResourceManagerConf8(pluginXStream);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ReflectiveOperationException var7) {
            throw new ServiceException("Confluence WebResourceManager couldn't be initialized.", (Throwable)var7);
        }
        return internalDelegate;
    }

    @Override
    public void requireResource(String resource) {
        this.delegate.get().requireResource(resource);
    }

    private Object getConfluenceWebResourceConf9(ClassLoader classLoader) throws ReflectiveOperationException {
        return ComponentLocator.getComponent(Class.forName("com.atlassian.webresource.api.WebResourceManager", true, classLoader));
    }

    private Object getConfluenceWebResourceConf8(ClassLoader classLoader) throws ReflectiveOperationException {
        return ComponentLocator.getComponent(Class.forName("com.atlassian.plugin.webresource.WebResourceManager", true, classLoader));
    }
}

