/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function(CW, $) {
    CW.toInit(function () {
        // Signing Token User Profile Tab
        var SigningTokenUserProfileIframe = new CW.iframe({
            id: 'SigningTokenUserProfileIframe',
            url: '/user/config/esignature/',
            width: '100%',
            height: '100%',
            query: {
                userKey: CW.getParam('remoteUserKey')
            }
        });
        $('#cw-esignatures-user-profile').html(SigningTokenUserProfileIframe.render());
    });
});