/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.query;

import java.util.Comparator;
import java.util.List;
import net.customware.confluence.reporting.Sortable;
import net.customware.confluence.reporting.query.AbstractQuery;
import net.customware.confluence.reporting.query.Query;
import net.customware.confluence.reporting.query.QueryException;
import net.customware.confluence.reporting.query.Queryable;
import net.customware.confluence.reporting.query.Results;
import org.apache.commons.collections.ComparatorUtils;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutatorQuery<From, To, Sort>
extends AbstractQuery<To>
implements Queryable<From>,
Sortable<Sort> {
    private Query<? extends From> query;
    private Class<From> fromType;
    private Class<To> toType;
    private Comparator<? super Sort> comparator;

    public AbstractMutatorQuery(Class<From> from, Class<To> to, MacroInfo info) throws QueryException {
        this(from, to, info, null);
    }

    public AbstractMutatorQuery(Class<From> from, Class<To> to, MacroInfo info, Query<? extends From> query) throws QueryException {
        super(info);
        this.query = query;
        this.fromType = from;
        this.toType = to;
    }

    @Override
    protected void findItems(List<To> items, Criteria criteria) throws QueryException {
        Results<From> fromItems = null;
        if (this.query != null) {
            fromItems = this.query.execute();
        }
        Results<To> toItems = this.mutate(fromItems);
        fromItems.close();
        while (toItems.hasNext()) {
            items.add(toItems.next());
        }
    }

    protected abstract Results<? extends To> mutate(Results<? extends From> var1) throws QueryException;

    public Class<From> getFromType() {
        return this.fromType;
    }

    public Class<To> getToType() {
        return this.toType;
    }

    @Override
    public boolean addQuery(Query<? extends From> query) {
        if (this.query == null) {
            this.query = query;
        }
        return false;
    }

    @Override
    public boolean canAddQuery() {
        return this.query == null;
    }

    @Override
    public Class<From> getQueryValueType() {
        return this.fromType;
    }

    @Override
    public Class<To> getValueType() {
        return this.toType;
    }

    @Override
    public boolean addComparator(Comparator<? super Sort> comparator) {
        this.comparator = this.comparator == null ? comparator : ComparatorUtils.chainedComparator(this.comparator, comparator);
        return true;
    }

    protected void clearComparators() {
        this.comparator = null;
    }

    @Override
    public Comparator<? super Sort> getComparator() {
        return this.comparator;
    }
}

