/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.search.v2.SearchSort;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflowreports.model.TasksReportFilter;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WorkflowReportOptions {
    public static final String ALL_SPACES_PARAM = "any";
    private int maxEntries;
    private String spaceKey;
    private WorkflowReportSortEnum sort;
    private String stateNameAsString;
    private String approvalName;
    private String approvalFilter;
    private TasksReportFilter tasksFilter;
    private boolean approvalsReport;
    private boolean statesReport;
    private boolean pageReport;
    private boolean dashboardReport;
    private boolean tasksReport;
    private boolean statsReport;
    private boolean statesActionReport = false;
    private String userName;
    private String approverName;
    private String assignee;
    private String parentId;
    private List<Label> labels;
    private boolean mustHaveAllLabels;
    private boolean hideHeader;
    private SearchSort customSort;
    private Map<String, String> filterTerms;
    private List<String> stateNames;

    public WorkflowReportOptions(String spaceKey, String defaultSpaceKey, WorkflowReportSortEnum sort, int maxEntries) {
        if (spaceKey != null) {
            if (spaceKey.startsWith("@")) {
                spaceKey = spaceKey.substring(1);
            }
            if (spaceKey.equalsIgnoreCase(ALL_SPACES_PARAM) || spaceKey.equalsIgnoreCase("all")) {
                spaceKey = null;
            } else if (spaceKey.equals("self")) {
                spaceKey = defaultSpaceKey;
            }
            this.spaceKey = spaceKey;
        }
        this.sort = sort;
        this.maxEntries = maxEntries;
        this.approvalsReport = false;
        this.statesReport = false;
        this.labels = new ArrayList<Label>();
        this.mustHaveAllLabels = false;
        this.hideHeader = false;
        this.tasksReport = false;
        this.tasksFilter = TasksReportFilter.getDefault();
        this.filterTerms = new HashMap<String, String>();
        this.stateNames = new ArrayList<String>();
    }

    private void addFilterTerm(String key, String value) {
        this.filterTerms.put(key, value);
    }

    public void setFilters(String filters) {
        for (String filter : MiscUtils.splitAndTrim(filters)) {
            int ix = filter.indexOf(":");
            if (ix < 0 || ix == filter.length() - 1) continue;
            this.addFilterTerm(filter.substring(0, ix), filter.substring(ix + 1));
        }
    }

    public void setApprovalFilter(String approvalFilter, String approvalName) {
        this.approvalFilter = approvalFilter;
        this.approvalName = approvalName;
    }

    public void setStateNames(String stateNames) {
        this.stateNameAsString = stateNames;
        this.stateNames = Arrays.asList(MiscUtils.splitAndTrim(stateNames));
    }

    public void setUserName(String userName) {
        this.userName = userName;
        if (userName != null) {
            this.approvalFilter = "pending";
        }
    }

    public SearchSort getSearchSort() {
        if (this.customSort != null) {
            return this.customSort;
        }
        return this.sort.getSort();
    }

    public void addLabel(Label label) {
        this.labels.add(label);
    }

    public boolean isPending() {
        return "pending".equalsIgnoreCase(this.approvalFilter);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public List<TasksReportFilter> getTasksFilters() {
        return TasksReportFilter.ALL_FILTERS;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSort(WorkflowReportSortEnum sort) {
        this.sort = sort;
    }

    public WorkflowReportSortEnum getSort() {
        return this.sort;
    }

    public String getStateNameAsString() {
        return this.stateNameAsString;
    }

    public String getApprovalName() {
        return this.approvalName;
    }

    public String getApprovalFilter() {
        return this.approvalFilter;
    }

    public TasksReportFilter getTasksFilter() {
        return this.tasksFilter;
    }

    public void setTasksFilter(TasksReportFilter tasksFilter) {
        this.tasksFilter = tasksFilter;
    }

    public void setApprovalsReport(boolean approvalsReport) {
        this.approvalsReport = approvalsReport;
    }

    public boolean isApprovalsReport() {
        return this.approvalsReport;
    }

    public void setStatesReport(boolean statesReport) {
        this.statesReport = statesReport;
    }

    public boolean isStatesReport() {
        return this.statesReport;
    }

    public void setPageReport(boolean pageReport) {
        this.pageReport = pageReport;
    }

    public boolean isPageReport() {
        return this.pageReport;
    }

    public void setDashboardReport(boolean dashboardReport) {
        this.dashboardReport = dashboardReport;
    }

    public boolean isDashboardReport() {
        return this.dashboardReport;
    }

    public void setTasksReport(boolean tasksReport) {
        this.tasksReport = tasksReport;
    }

    public boolean isTasksReport() {
        return this.tasksReport;
    }

    public void setStatsReport(boolean statsReport) {
        this.statsReport = statsReport;
    }

    public boolean isStatsReport() {
        return this.statsReport;
    }

    public void setStatesActionReport(boolean statesActionReport) {
        this.statesActionReport = statesActionReport;
    }

    public boolean isStatesActionReport() {
        return this.statesActionReport;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public String getApproverName() {
        return this.approverName;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setMustHaveAllLabels(boolean mustHaveAllLabels) {
        this.mustHaveAllLabels = mustHaveAllLabels;
    }

    public boolean isMustHaveAllLabels() {
        return this.mustHaveAllLabels;
    }

    public void setHideHeader(boolean hideHeader) {
        this.hideHeader = hideHeader;
    }

    public boolean isHideHeader() {
        return this.hideHeader;
    }

    public void setCustomSort(SearchSort customSort) {
        this.customSort = customSort;
    }

    public Map<String, String> getFilterTerms() {
        return this.filterTerms;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }
}

