/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.action;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractCommandAction;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageReportCommand
extends AbstractCommandAction
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(PageReportCommand.class);
    private long pageId;
    private AbstractPage page;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private PermissionManager permissionManager;
    protected StateAccessor stateAccessor;
    protected ApprovalManager approvalManager;
    protected WorkflowConfigurationManager workflowConfigurationManager;
    @ComponentImport
    protected AccessModeService accessModeService;
    protected GlobalSettingsManager settingsManager;
    protected LocaleManager localeManager;

    public abstract void doExecuteInternal(AbstractPage var1);

    public abstract boolean requiresEditPermission();

    public abstract boolean requiresSpaceAdminPermission();

    protected ServiceCommand createCommand() {
        return new PageReportServiceCommand();
    }

    public AbstractPage getPage() {
        if (this.page == null) {
            this.page = this.pageManager.getAbstractPage(this.pageId);
        }
        return this.page;
    }

    public long getPageId() {
        return this.pageId;
    }

    @ParameterSafe
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setStateAccessor(StateAccessor stateAccessor) {
        this.stateAccessor = stateAccessor;
    }

    public void setApprovalManager(ApprovalManager approvalManager) {
        this.approvalManager = approvalManager;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public void setSettingsManager(GlobalSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    private class PageReportServiceCommand
    extends AbstractServiceCommand {
        private PageReportServiceCommand() {
        }

        protected void validateInternal(ServiceCommandValidator validator) {
        }

        protected boolean isAuthorizedInternal() {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (PageReportCommand.this.getPage() == null) {
                return false;
            }
            if (PageReportCommand.this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
                return true;
            }
            if (!PageReportCommand.this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)PageReportCommand.this.getPage())) {
                return false;
            }
            if (PageReportCommand.this.requiresSpaceAdminPermission()) {
                return PageReportCommand.this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)PageReportCommand.this.getPage().getSpace());
            }
            if (PageReportCommand.this.requiresEditPermission()) {
                return this.canEdit(user, PageReportCommand.this.getPage());
            }
            return true;
        }

        protected boolean canEdit(ConfluenceUser user, AbstractPage page) {
            return (Boolean)PageReportCommand.this.accessModeService.withReadOnlyAccessExemption(() -> PageReportCommand.this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page));
        }

        protected void executeInternal() {
            try {
                PageReportCommand.this.doExecuteInternal(PageReportCommand.this.getPage());
            }
            catch (Exception e) {
                PageReportCommand.this.addActionError("approvalsworkflow.workflow.error", new String[]{e.getMessage()});
                log.error("error on page " + PageReportCommand.this.getPage(), (Throwable)e);
            }
        }
    }
}

