/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.webresource.compat.WebResourceManagerCompat;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.opensymphony.xwork2.ActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceWorkflowsAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowsAction.class);
    private WorkflowConfigurationManager workflowConfigurationManager;
    @ComponentImport
    private WikiStyleRenderer wikiStyleRenderer;
    private WebResourceManagerCompat webResourceManagerCompat;
    private AdhocWorkflowsLicenseManager licenseManager;
    private String workflowName;
    private boolean showWelcome;
    private String welcomeUrl;
    private String licenseStatusMessage;
    private String workflowsVersionNumber;
    private String workflowsVersionName;
    private static final ThreadLocal<String> errorMessageThreadLocal = new ThreadLocal();
    private final String docoUrl = "https://apps.appf.re/cdmdc/doc/documentmanagementdash/qe9E5b";

    public String execute() throws Exception {
        this.webResourceManagerCompat.requireResource("confluence.web.resources:jquery");
        this.webResourceManagerCompat.requireResource("confluence.web.resources:ajs");
        this.showWelcome = this.workflowConfigurationManager.getConfiguration().isShowWelcome();
        this.welcomeUrl = this.workflowConfigurationManager.getConfiguration().getWelcomeUrl();
        this.licenseStatusMessage = this.licenseManager.getLicenseStatus().getMessageHtml();
        this.workflowsVersionNumber = this.workflowConfigurationManager.getConfiguration().getWorkflowVersionNumber();
        this.workflowsVersionName = this.workflowConfigurationManager.getConfiguration().getWorkflowVersionName();
        return "success";
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    private void clearErrorMessage() {
        errorMessageThreadLocal.remove();
    }

    public String getErrorMessage() {
        String message = errorMessageThreadLocal.get();
        this.clearErrorMessage();
        return message;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setWebResourceManagerCompat(WebResourceManagerCompat webResourceManagerCompat) {
        this.webResourceManagerCompat = webResourceManagerCompat;
    }

    public String render(String body) {
        PageContext context = new PageContext(this.getSpaceKey());
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isShowWelcome() {
        return this.showWelcome;
    }

    public String getWelcomeUrl() {
        return this.welcomeUrl;
    }

    public String getWorkflowsVersionNumber() {
        return this.workflowsVersionNumber;
    }

    public String getWorkflowsVersionName() {
        return this.workflowsVersionName;
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.space) && (!"promoteSpaceWorkflow".equals(ActionContext.getContext().getActionName()) || this.isConfluenceAdministrator());
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public WorkflowConfigurationManager getWorkflowConfigurationManager() {
        return this.workflowConfigurationManager;
    }

    @HtmlSafe
    public String getLicenseStatusMessage() {
        return this.licenseStatusMessage;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getDocoUrl() {
        return "https://apps.appf.re/cdmdc/doc/documentmanagementdash/qe9E5b";
    }

    public WebResourceManagerCompat getWebResourceManagerCompat() {
        return this.webResourceManagerCompat;
    }
}

