/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.transformer;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageSectionsManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.transformer.AbstractTransformer;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class WorkflowsPostRenderTransformer
extends AbstractTransformer {
    public static final String DATA_LINKED_RESOURCE_VERSION = "data-linked-resource-version";
    public static final List<String> FORBIDDEN_IMG_ATTRIBUTES = ImmutableList.of("data-unresolved-comment-count");
    protected final AttachmentManager attachmentManager;
    protected final PageSectionsManager pageSectionsManager;
    protected final WorkflowAccessor workflowAccessor;
    protected final ApprovalAccessor approvalAccessor;
    protected final Renderer renderer;
    protected final PageManager pageManager;
    protected AbstractPage page = null;

    public WorkflowsPostRenderTransformer(AttachmentManager attachmentManager, PageSectionsManager pageSectionsManager, WorkflowAccessor workflowAccessor, ApprovalAccessor approvalAccessor, Renderer renderer, PageManager pageManager) {
        this.attachmentManager = attachmentManager;
        this.pageSectionsManager = pageSectionsManager;
        this.workflowAccessor = workflowAccessor;
        this.approvalAccessor = approvalAccessor;
        this.renderer = renderer;
        this.pageManager = pageManager;
    }

    @Override
    public boolean shouldApply(String content, ConversionContext context) {
        ContentEntityObject ceo = context.getEntity();
        if (!(ceo instanceof AbstractPage) || !ceo.isCurrent()) {
            return false;
        }
        if (this.maybeIsMacroRendering(context)) {
            return false;
        }
        this.page = (AbstractPage)ceo;
        return true;
    }

    @Override
    public String transform(String content, ConversionContext context) throws XhtmlException {
        if (!context.hasProperty("snapshots-mode")) {
            content = this.rerenderIfTocMacroHasRendered(content, context);
            content = this.transformPublishedAttachmentLinks(content, context);
        }
        content = this.addWorkflowHeaderFooter(this.page, content, context);
        return content;
    }

    private boolean maybeIsMacroRendering(ConversionContext context) {
        return context.getProperty("macroName") != null;
    }

    protected String rerenderIfTocMacroHasRendered(String content, ConversionContext context) {
        try {
            MacroDefinition macroDefinition;
            String outputType = context.getOutputType();
            if ((outputType.equalsIgnoreCase("pdf") || outputType.equalsIgnoreCase("word") && context.getProperty("macroDefinition") != null) && (macroDefinition = (MacroDefinition)context.getProperty("macroDefinition")).getName().equals("toc")) {
                return this.rerenderReleasedPageVersion(content, outputType);
            }
            return content;
        }
        catch (Exception ex) {
            return content;
        }
    }

    protected String rerenderReleasedPageVersion(String content, String outputType) {
        AbstractPage releasedPage;
        ApprovalCheck approvalCheck = this.approvalAccessor.getFinalApprovalCheck(this.page);
        if (approvalCheck != null && approvalCheck.getVersion() != this.page.getVersion() && (releasedPage = (AbstractPage)this.pageManager.getPageByVersion(this.page, approvalCheck.getVersion()).clone()) != null) {
            PageContext releasedPageContext = releasedPage.toPageContext();
            releasedPageContext.setOutputType(outputType);
            DefaultConversionContext releasedPageConversionContext = new DefaultConversionContext((RenderContext)releasedPageContext);
            return this.renderer.render((ContentEntityObject)releasedPage, (ConversionContext)releasedPageConversionContext);
        }
        return content;
    }

    protected String addWorkflowHeaderFooter(AbstractPage page, String content, ConversionContext context) {
        PageWorkflows pageWorkflows;
        String outputType = context.getOutputType();
        if ((outputType.equalsIgnoreCase("pdf") || outputType.equalsIgnoreCase("word")) && context.getProperty("workflowPage") != null && (pageWorkflows = this.workflowAccessor.getPageWorkflows(page)) != null) {
            boolean publishedView = context.getProperty("releaseview") != null;
            PageSectionsManager.PageSections pageSections = this.pageSectionsManager.renderPageSections(pageWorkflows, context, publishedView);
            content = pageSections.getHeader() + (String)content + pageSections.getFooter();
        }
        return content;
    }

    protected String transformPublishedAttachmentLinks(String content, ConversionContext context) {
        ApprovalCheck.CheckedAttachment[] publishedAttachments;
        ApprovalCheck finalApprovalCheck;
        if (context.getProperty("releaseview") != null && (finalApprovalCheck = this.approvalAccessor.getFinalApprovalCheck(this.page.getLatestVersion())) != null && (publishedAttachments = finalApprovalCheck.getAttachments()) != null && publishedAttachments.length > 0) {
            Document htmlDoc = this.getParsedDocument(content);
            Elements imgElements = htmlDoc.select("img.confluence-embedded-image");
            this.transformElementsVersionUrl(publishedAttachments, imgElements, "src");
            this.transformElementsVersionUrl(publishedAttachments, imgElements, "data-image-src");
            this.transformElementsAttributes(publishedAttachments, imgElements, DATA_LINKED_RESOURCE_VERSION);
            this.removeElementsAttributes(imgElements, FORBIDDEN_IMG_ATTRIBUTES);
            Elements linkElementsAttachments = htmlDoc.select("a[href*=download/attachments]");
            this.transformElementsVersionUrl(publishedAttachments, linkElementsAttachments, "href");
            this.transformElementsAttributes(publishedAttachments, linkElementsAttachments, DATA_LINKED_RESOURCE_VERSION);
            this.transformElementsVersionUrl(publishedAttachments, linkElementsAttachments, "data-file-src");
            this.transformElementsThumbnailImage(publishedAttachments, linkElementsAttachments, "src");
            this.removeElementsAttributes(linkElementsAttachments, FORBIDDEN_IMG_ATTRIBUTES);
            htmlDoc.outputSettings().indentAmount(0).prettyPrint(false);
            if (htmlDoc.body() == null || htmlDoc.body().childNodeSize() == 0) {
                return htmlDoc.html().replace("<html><body></body></html>", "");
            }
            return htmlDoc.body().html();
        }
        return content;
    }

    private Document getParsedDocument(String content) {
        if (content.contains("/>")) {
            return Jsoup.parse(content, "", Parser.xmlParser());
        }
        return Jsoup.parseBodyFragment(content);
    }

    private void transformElementsThumbnailImage(ApprovalCheck.CheckedAttachment[] publishedAttachments, Elements elements, String attrName) {
        for (Element element : elements) {
            String attId = element.attr("data-linked-resource-id");
            Element thumbImg = element.select("img").first();
            if (attId == null || thumbImg == null) {
                return;
            }
            for (ApprovalCheck.CheckedAttachment checkedAttachment : publishedAttachments) {
                Attachment attachment = this.attachmentManager.getAttachment(checkedAttachment.getId());
                if (attachment == null || !Long.toString(attachment.getId()).equals(attId)) continue;
                String versionedThumbnailPath = thumbImg.attr(attrName);
                Matcher m = Pattern.compile("/conversion/thumbnail/" + attId + "/(\\d+)").matcher(versionedThumbnailPath);
                if (m == null || !m.find()) continue;
                versionedThumbnailPath = m.replaceAll("/conversion/thumbnail/" + attId + "/" + checkedAttachment.getVersion());
                thumbImg.attr(attrName, versionedThumbnailPath);
            }
        }
    }

    private void removeElementsAttributes(Elements imgElements, List<String> forbiddenAttributes) {
        for (Element img : imgElements) {
            for (Attribute attribute : img.attributes().asList()) {
                if (!forbiddenAttributes.contains(attribute.getKey())) continue;
                img.removeAttr(attribute.getKey());
            }
        }
    }

    private void transformElementsUrl(ApprovalCheck.CheckedAttachment[] publishedAttachments, Elements elements, String attrName, String paramName) {
        block0: for (Element element : elements) {
            String attrValue = element.attr(attrName);
            for (ApprovalCheck.CheckedAttachment checkedAttachment : publishedAttachments) {
                Attachment attachment = this.attachmentManager.getAttachment(checkedAttachment.getId());
                if (attachment == null) continue;
                String downloadPath = attachment.getDownloadPath();
                String thumbnailPath = downloadPath.replace("download/attachments", "download/thumbnails");
                if (!attrValue.contains(downloadPath) && !attrValue.contains(thumbnailPath)) continue;
                String replaced = attrValue.replaceAll(paramName + "=[0-9]+", paramName + "=" + checkedAttachment.getVersion());
                element.attr(attrName, replaced);
                continue block0;
            }
        }
    }

    private void transformElementsVersionUrl(ApprovalCheck.CheckedAttachment[] publishedAttachments, Elements elements, String attrName) {
        this.transformElementsUrl(publishedAttachments, elements, attrName, "version");
    }

    private void transformElementsAttributes(ApprovalCheck.CheckedAttachment[] publishedAttachments, Elements elements, String attrName) {
        block0: for (Element element : elements) {
            if (!StringUtils.isNotBlank((CharSequence)element.attr(attrName))) {
                return;
            }
            String hrefUrl = element.attr("href");
            if (!StringUtils.isNotBlank((CharSequence)hrefUrl)) {
                hrefUrl = element.attr("src");
            }
            for (ApprovalCheck.CheckedAttachment checkedAttachment : publishedAttachments) {
                Attachment attachment = this.attachmentManager.getAttachment(checkedAttachment.getId());
                if (attachment == null) continue;
                String downloadPath = attachment.getDownloadPath();
                String versionlessDownloadPath = downloadPath.contains("?") ? downloadPath.split("\\?")[0] : downloadPath;
                String thumbnailPath = versionlessDownloadPath.replace("download/attachments", "download/thumbnails");
                if (!hrefUrl.contains(versionlessDownloadPath) && !hrefUrl.contains(thumbnailPath)) continue;
                element.attr(attrName, "" + checkedAttachment.getVersion());
                continue block0;
            }
        }
    }
}

