/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflow.model.WorkflowPageFooter;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.parser.WorkflowPreProcessor;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.workflow.model.TasksMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkflowMapper
implements Mapper<Workflow, RestWorkflow> {
    @Override
    public RestWorkflow toRest(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        RestWorkflow restWorkflow = new RestWorkflow();
        restWorkflow.key = workflow.getKey();
        restWorkflow.name = workflow.getName();
        restWorkflow.description = workflow.getDescription();
        restWorkflow.blueprintKey = workflow.getBlueprintKey();
        restWorkflow.css = workflow.getCssUrl();
        restWorkflow.active = workflow.isActive() ? Boolean.valueOf(true) : null;
        restWorkflow.adhoc = workflow.isAdhoc() ? Boolean.valueOf(true) : null;
        restWorkflow.adminUsers = workflow.getAdminUserNames();
        restWorkflow.displayProgressTracker = workflow.isDisplayProgressTracker() ? Boolean.valueOf(true) : null;
        Boolean bl = restWorkflow.updateStatus = workflow.isUpdateStatus() ? Boolean.valueOf(true) : null;
        if (workflow.isPageReadConfirmation()) {
            restWorkflow.pageReadConfirmation = workflow.isPageReadConfirmation();
        }
        switch (workflow.getHideStatus()) {
            case 1: {
                restWorkflow.hideStatus = RestWorkflow.HideStatus.HIDE;
                break;
            }
            case 2: {
                restWorkflow.hideStatus = RestWorkflow.HideStatus.READ_ONLY;
            }
        }
        restWorkflow.hideStates = workflow.isHideStates() ? Boolean.valueOf(true) : null;
        restWorkflow.tip = workflow.getTip();
        if (workflow.getTasksMode() != null) {
            switch (workflow.getTasksMode()) {
                case STRICT: {
                    restWorkflow.taskMode = RestWorkflow.TaskMode.STRICT;
                    break;
                }
                case LENIENT: {
                    restWorkflow.taskMode = RestWorkflow.TaskMode.LENIENT;
                }
            }
        }
        restWorkflow.contentTypes = new ArrayList<RestWorkflow.ContentType>();
        if (workflow.isPageWorkflow() || workflow.isPageReadConfirmation()) {
            restWorkflow.contentTypes.add(RestWorkflow.ContentType.PAGE);
        }
        if (workflow.isBlogPostWorkflow()) {
            restWorkflow.contentTypes.add(RestWorkflow.ContentType.BLOGPOST);
        }
        if (workflow.getLabels() != null && workflow.getLabels().size() > 0) {
            restWorkflow.labels = workflow.getLabels().stream().map(Label::getName).collect(Collectors.toList());
        }
        if (workflow.getStickyLabels() != null && workflow.getStickyLabels().size() > 0) {
            restWorkflow.stickyLabels = workflow.getStickyLabels().stream().map(Label::getName).collect(Collectors.toList());
        }
        Boolean bl2 = restWorkflow.invertLabels = workflow.isInvertLabels() ? Boolean.valueOf(true) : null;
        if (workflow.getWorkflowPagePageHeader() != null) {
            restWorkflow.pageHeader = Mappers.workflowSectionMapper.toRest(workflow.getWorkflowPagePageHeader());
        }
        if (workflow.getWorkflowPagePageFooter() != null) {
            restWorkflow.pageFooter = Mappers.workflowSectionMapper.toRest(workflow.getWorkflowPagePageFooter());
        }
        if (workflow.getCreateInstructions() != null) {
            restWorkflow.instructions = Mappers.instructionMapper.toRest(workflow.getCreateInstructions());
        }
        if (workflow.getWorkflowParameters() != null && workflow.getWorkflowParameters().size() > 0) {
            restWorkflow.parameters = workflow.getWorkflowParameters().stream().map(Mappers.parameterMapper::toRest).collect(Collectors.toList());
        }
        if (workflow.getStatesContainer() != null) {
            restWorkflow.states = workflow.getStatesContainer().getStates().stream().map(Mappers.stateMapper::toRest).collect(Collectors.toList());
        }
        if (workflow.getReadAck() != null) {
            restWorkflow.readAck = Mappers.readAckMapper.toRest(workflow.getReadAck());
        }
        if (workflow.getExplicitTriggers() != null && workflow.getExplicitTriggers().size() > 0) {
            restWorkflow.triggers = workflow.getExplicitTriggers().stream().map(Mappers.triggerMapper::toRest).collect(Collectors.toList());
            restWorkflow.blobTriggers = workflow.getOrderedElementList().stream().filter(e -> e instanceof Trigger).map(t -> ((Macroable)((Object)t)).toMacro().toString()).collect(Collectors.joining());
        }
        return restWorkflow;
    }

    @Override
    public Workflow fromRest(RestWorkflow restWorkflow) {
        Workflow workflow = new Workflow();
        workflow.setKey(restWorkflow.key);
        workflow.setName(restWorkflow.name);
        workflow.setDescription(restWorkflow.description);
        workflow.setBlueprintKey(restWorkflow.blueprintKey);
        workflow.setCssUrl(restWorkflow.css);
        workflow.setActive(BooleanUtils.isTrue((Boolean)restWorkflow.active));
        workflow.setAdhoc(BooleanUtils.isTrue((Boolean)restWorkflow.adhoc));
        workflow.setAdminUserNames(restWorkflow.adminUsers);
        workflow.setDisplayProgressTracker(BooleanUtils.isTrue((Boolean)restWorkflow.displayProgressTracker));
        workflow.setUpdateStatus(BooleanUtils.isTrue((Boolean)restWorkflow.updateStatus));
        workflow.setPageReadConfirmation(BooleanUtils.isTrue((Boolean)restWorkflow.pageReadConfirmation));
        if (restWorkflow.hideStatus != null) {
            switch (restWorkflow.hideStatus) {
                case SHOW: {
                    workflow.setHideStatus(0);
                    break;
                }
                case HIDE: {
                    workflow.setHideStatus(1);
                    break;
                }
                case READ_ONLY: {
                    workflow.setHideStatus(2);
                }
            }
        }
        workflow.setHideStates(BooleanUtils.isTrue((Boolean)restWorkflow.hideStates));
        workflow.setTip(restWorkflow.tip);
        if (restWorkflow.taskMode != null) {
            switch (restWorkflow.taskMode) {
                case DEFAULT: {
                    workflow.setTasksMode(TasksMode.DEFAULT);
                    break;
                }
                case STRICT: {
                    workflow.setTasksMode(TasksMode.STRICT);
                    break;
                }
                case LENIENT: {
                    workflow.setTasksMode(TasksMode.LENIENT);
                }
            }
        }
        if (restWorkflow.contentTypes != null) {
            if (!restWorkflow.contentTypes.contains((Object)RestWorkflow.ContentType.PAGE)) {
                workflow.setPageWorkflow(false);
                workflow.setPageReadConfirmation(false);
            }
            if (!restWorkflow.contentTypes.contains((Object)RestWorkflow.ContentType.BLOGPOST)) {
                workflow.setBlogPostWorkflow(false);
            }
        }
        if (restWorkflow.labels != null) {
            workflow.setLabels(restWorkflow.labels.stream().map(Label::new).collect(Collectors.toList()));
        }
        if (restWorkflow.stickyLabels != null) {
            workflow.setStickyLabels(restWorkflow.stickyLabels.stream().map(Label::new).collect(Collectors.toList()));
        }
        workflow.setInvertLabels(BooleanUtils.isTrue((Boolean)restWorkflow.invertLabels));
        if (restWorkflow.instructions != null) {
            workflow.setCreateInstructions(Mappers.instructionMapper.fromRest(restWorkflow.instructions));
        }
        List<WorkflowElement> elements = new ArrayList<WorkflowElement>();
        if (restWorkflow.pageHeader != null) {
            elements.add(Mappers.workflowSectionMapper.fromRest(restWorkflow.pageHeader));
        }
        if (restWorkflow.pageFooter != null) {
            elements.add((WorkflowElement)Mappers.workflowSectionMapper.fromRest(restWorkflow.pageFooter, WorkflowPageFooter.class));
        }
        if (restWorkflow.parameters != null) {
            elements.addAll(restWorkflow.parameters.stream().map(Mappers.parameterMapper::fromRest).collect(Collectors.toList()));
        }
        if (restWorkflow.states != null) {
            elements.addAll(restWorkflow.states.stream().map(Mappers.stateMapper::fromRest).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (restWorkflow.readAck != null) {
            elements.add(Mappers.readAckMapper.fromRest(restWorkflow.readAck));
        }
        WorkflowParser workflowParser = PluginContainerManager.getComponent(WorkflowParser.class);
        if (StringUtils.isNotBlank((CharSequence)restWorkflow.blobTriggers) && workflowParser != null) {
            try {
                PageContext currentContext = new Page().toPageContext();
                currentContext.addParam((Object)"workflow", elements);
                currentContext.addParam((Object)"loadContextElements", (Object)true);
                Workflow parsedWorkflow = workflowParser.parseWorkflow("{workflow}" + restWorkflow.blobTriggers + "{workflow}", (RenderContext)currentContext);
                elements = Stream.of(elements, parsedWorkflow.getOrderedElementList()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            catch (WorkflowException ex) {
                throw new MapperException("Error parsing blobTriggers", ex);
            }
        } else if (restWorkflow.triggers != null) {
            elements.addAll(restWorkflow.triggers.stream().map(Mappers.triggerMapper::fromRest).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        try {
            workflow.registerElements(elements);
        }
        catch (WorkflowException ex) {
            throw new MapperException("Error registering elements into workflow instance", ex);
        }
        WorkflowPreProcessor preProcessor = new WorkflowPreProcessor(ComalaI18nBean.getComalaI18nBean());
        try {
            preProcessor.process(workflow);
        }
        catch (WorkflowException ex) {
            throw new MapperException("Error preprocessing the workflow instance", ex);
        }
        return workflow;
    }
}

