/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

@XmlRootElement(name="restParameter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestParameter {
    public String name;
    public Type type;
    public String description;
    public String options;
    public Boolean editable;
    public String value;

    public RestParameter() {
    }

    public RestParameter(String name, Type type, String description, String options, Boolean editable, String value) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.options = options;
        this.editable = editable;
        this.value = value;
    }

    @XmlType(name="parameterType")
    @XmlEnum
    public static enum Type {
        STRING("string"),
        USER("user"),
        GROUP("group"),
        USERORGROUP("userorgroup"),
        DURATION("duration"),
        OPTIONS("options");

        public static Type DEFAULT;
        private static Map<String, Type> FORMAT_MAP;
        private final String formatted;

        private Type(String formatted) {
            this.formatted = formatted;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        @JsonCreator
        public static Type fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        @com.fasterxml.jackson.annotation.JsonValue
        @JsonValue
        public String toString() {
            return this.formatted;
        }

        static {
            DEFAULT = STRING;
            FORMAT_MAP = Stream.of(Type.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }
}

