/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.accessor;

import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowMarkupManager
implements WorkflowMarkupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowMarkupManager.class);
    private final WorkflowParser workflowParser;

    public DefaultWorkflowMarkupManager(WorkflowParser workflowParser) {
        this.workflowParser = workflowParser;
    }

    @Override
    public void validateJsonMarkup(String jsonMarkup) throws MarkupValidationException {
        try {
            this.getSchema("/workflows/schema-workflow.json").validate(new JSONObject(jsonMarkup));
        }
        catch (ValidationException vex) {
            throw new MarkupValidationException(vex.getAllMessages());
        }
    }

    private Schema getSchema(String jsonSchema) {
        InputStream inputStream = this.getClass().getResourceAsStream(jsonSchema);
        JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
        return SchemaLoader.load(rawSchema);
    }

    @Override
    public void validateJsonMarkup(RestWorkflow workflow) throws MarkupValidationException {
        try {
            String json = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(workflow);
            if (log.isDebugEnabled()) {
                log.debug("Validating JSON markup against schema\n" + json);
            }
            this.validateJsonMarkup(json);
        }
        catch (IOException ex) {
            log.error("Error parsing the json markup", (Throwable)ex);
        }
    }

    @Override
    public Workflow parseFromWikiMarkup(String wikiMarkup) {
        try {
            return this.workflowParser.parseWorkflow(wikiMarkup);
        }
        catch (WorkflowException ex) {
            return null;
        }
    }

    @Override
    public Workflow parseFromJsonMarkup(String jsonMarkup) throws MarkupValidationException {
        this.validateJsonMarkup(jsonMarkup);
        try {
            RestWorkflow restWorkflow = new ObjectMapper().readValue(jsonMarkup, RestWorkflow.class);
            return Mappers.workflowMapper.fromRest(restWorkflow);
        }
        catch (IOException ex) {
            log.error("Error parsing the json markup", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String convertToJson(Workflow workflow) {
        RestWorkflow restWorkflow = Mappers.workflowMapper.toRest(workflow);
        try {
            if (Objects.nonNull(restWorkflow.description)) {
                restWorkflow.description = restWorkflow.description.replaceAll("[\\n\\t]", "").replaceAll("^ +| +$|( )+", "$1");
            }
            return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(restWorkflow);
        }
        catch (IOException ex) {
            log.error("Error parsing the json markup", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Optional<String> validateJsonMarkup(String jsonMarkup, String jsonSchema) {
        try {
            this.getSchema(jsonSchema).validate(new JSONObject(jsonMarkup));
            return Optional.empty();
        }
        catch (ValidationException e) {
            return Optional.ofNullable(e.toString());
        }
    }
}

