/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.NotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import com.comalatech.confluence.workflow.mywork.AdhocInAppNotificationService;
import com.comalatech.confluence.workflow.mywork.NotificationServiceAccessor;
import com.comalatech.confluence.workflow.mywork.NotificationServiceHolder;
import com.comalatech.confluence.workflow.mywork.notification.AdhocNotification;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AdhocInAppNotificationServiceImpl
implements AdhocInAppNotificationService {
    private static final Logger log = LoggerFactory.getLogger(AdhocInAppNotificationServiceImpl.class);
    protected final UserAccessor userAccessor;
    protected final HostApplication hostApplication;
    protected final GlobalSettingsManager globalSettingsManager;
    protected final NotificationServiceAccessor notificationServiceAccessor;
    protected NotificationServiceHolder notificationServiceHolder;
    protected final ContextPathHolder contextPathHolder;
    protected NotificationService notificationService;
    private final ObjectMapper objectMapper;
    protected static final String APPLICATION_KEY = "com.comalatech.confluence.workflow.mywork";

    public AdhocInAppNotificationServiceImpl(@ComponentImport UserAccessor userAccessor, @ComponentImport HostApplication hostApplication, NotificationServiceAccessor notificationServiceAccessor, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport ContextPathHolder contextPathHolder) {
        this.userAccessor = userAccessor;
        this.hostApplication = hostApplication;
        this.globalSettingsManager = globalSettingsManager;
        this.contextPathHolder = contextPathHolder;
        this.notificationServiceAccessor = notificationServiceAccessor;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected boolean isNotificationServiceAvailable() {
        this.notificationServiceHolder = this.notificationServiceAccessor.getNotificationService();
        if (this.notificationServiceHolder != null) {
            this.notificationService = (NotificationService)this.notificationServiceHolder.getNotificationService();
            return this.notificationService != null;
        }
        return false;
    }

    @Override
    public void sendNotification(AdhocNotification adhocNotification, List<String> usernames) {
        if (usernames != null && this.isNotificationServiceAvailable()) {
            for (String username : usernames) {
                String metadata = null;
                try {
                    metadata = this.objectMapper.writeValueAsString(adhocNotification.getMetadata(username));
                }
                catch (IOException e) {
                    log.error("Error during the serialisation of mywork metadata {}", (Object)e.getMessage());
                }
                Notification notification = new NotificationBuilder().application(APPLICATION_KEY).itemTitle(adhocNotification.getItemTitle()).itemUrl(adhocNotification.getItemUrlPath(username)).itemIconUrl(adhocNotification.getIconUrlPath()).description(adhocNotification.getDescription()).entity(adhocNotification.getEntity()).action(adhocNotification.getAction()).globalId(adhocNotification.globalId()).groupingId(adhocNotification.getGroupingId()).metadata(metadata != null ? metadata : "").iconUrl(this.getUserAvatarUrl(AuthenticatedUserThreadLocal.get())).applicationLinkId(this.hostApplication.getId().get()).createNotification();
                this.sendNotification(username, notification);
            }
        }
    }

    protected void sendNotification(String username, Notification notification) {
        this.notificationService.createOrUpdate(username, notification);
    }

    protected String getUserAvatarUrl(ConfluenceUser user) {
        String pictureUrl = "/images/icons/profilepics/default.gif";
        if (user != null && !WorkflowsFeatureManagerImpl.isWorkflowsUser(user.getName())) {
            pictureUrl = this.userAccessor.getUserProfilePicture((User)user).getUriReference();
            pictureUrl = pictureUrl.substring(this.contextPathHolder.getContextPath().length());
        }
        return pictureUrl;
    }

    protected String getBaseUrl() {
        return this.globalSettingsManager.getGlobalSettings().getBaseUrl();
    }
}

