/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ConditionHandler;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.HasViewWorkflowPermission;
import com.comalatech.confluence.workflow.model.UserCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public abstract class WorkflowElement
implements Serializable {
    protected List<Condition> conditions;

    protected WorkflowElement(List<Condition> conditions) {
        this.conditions = conditions == null ? new ArrayList<Condition>() : conditions;
    }

    public boolean evaluate(ValueStore valueStore) throws WorkflowException {
        boolean hasUserGroupConditionBeenMetYet = false;
        boolean hasAnyUserGroupConditions = false;
        for (Condition condition : this.conditions) {
            if (condition instanceof UserCondition || condition instanceof GroupCondition) {
                if (!hasUserGroupConditionBeenMetYet) {
                    hasUserGroupConditionBeenMetYet = condition.evaluate(valueStore);
                }
                hasAnyUserGroupConditions = true;
                continue;
            }
            if (condition.evaluate(valueStore)) continue;
            return false;
        }
        return hasAnyUserGroupConditions == hasUserGroupConditionBeenMetYet;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void prependCondition(Condition condition) {
        this.conditions.add(0, condition);
    }

    public void handleConditions(ConditionHandler handler) throws WorkflowException {
        for (Condition condition : this.conditions) {
            handler.handle(condition);
        }
    }

    public Predicate<Condition> hasUserCondition() {
        return condition -> condition instanceof UserCondition;
    }

    public Predicate<Condition> hasGroupCondition() {
        return condition -> condition instanceof GroupCondition;
    }

    public Predicate<Condition> hasViewPermissionCondition() {
        return condition -> condition instanceof HasViewWorkflowPermission;
    }

    public Predicate<Condition> hasApproverCondition() {
        return condition -> condition instanceof ApproverCondition;
    }
}

