/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import java.util.List;

public class CommonAnalyticsManager {
    protected final ApprovalsSearchService approvalsSearchService;
    protected final SpaceManager spaceManager;

    public CommonAnalyticsManager(ApprovalsSearchService approvalsSearchService, SpaceManager spaceManager) {
        this.approvalsSearchService = approvalsSearchService;
        this.spaceManager = spaceManager;
    }

    public long getActivePages() {
        return this.approvalsSearchService.getNumberOfPagesWithWorkflow();
    }

    public long getTotalPages() {
        long count = 0L;
        List spaces = this.spaceManager.getAllSpaces();
        for (Space space : spaces) {
            long pages = this.spaceManager.findPageTotal(space);
            count += pages;
        }
        return count;
    }

    public long getActiveSpaces() {
        return this.approvalsSearchService.getNumberOfSpacesWithWorkflow();
    }

    public long getTotalSpaces() {
        List spaces = this.spaceManager.getAllSpaces();
        return spaces.size();
    }
}

