/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.webresource.compat.WebResourceManagerCompat;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.actions.ViewPageCookieUtils;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import com.opensymphony.xwork2.ActionContext;
import java.util.Arrays;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewPageAction
extends com.atlassian.confluence.pages.actions.ViewPageAction
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(ViewPageAction.class);
    private static final String VIEW_RELEASED_RESULT = "viewreleased";
    private static final String[] EXCLUDED_PARAMS = new String[]{"pageId", "spaceKey", "title"};
    private ApprovalAccessor approvalAccessor;
    private WorkflowAccessor workflowAccessor;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private WebResourceManagerCompat webResourceManagerCompat;
    private WorkflowPermissionManager workflowPermissionManager;
    private StateService stateService;
    private ApprovalCheck approvalCheck;
    private boolean subjectToWorkflow = false;
    private boolean draft;
    public static final String NO_DRAFT_VIEW_PERMITTED_ERROR_I18N = "approvalsworkflow.approval.page.not.permitted";
    private ReportDateFormatter dateFormatter;

    private ApprovalCheck getApprovalCheck() {
        this.approvalCheck = this.approvalAccessor.getFinalApprovalCheck(this.getPage());
        return this.approvalCheck;
    }

    public String getActionParameters() {
        return this.getActionParameters("&");
    }

    public ReportDateFormatter getReportDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new ReportDateFormatter(this.getLocaleManager());
        }
        return this.dateFormatter;
    }

    public String getActionParameters(String firstSeparator) {
        HttpParameters actionParams = ActionContext.getContext().getParameters();
        StringBuilder sb = new StringBuilder();
        String separator = firstSeparator;
        for (Object name : actionParams.keySet()) {
            if (Arrays.binarySearch(EXCLUDED_PARAMS, name) >= 0) continue;
            Parameter value = (Parameter)actionParams.get(name);
            sb.append(separator).append(name).append('=').append(HtmlUtil.urlEncode((String)value.getValue()));
            separator = "&";
        }
        return sb.toString();
    }

    public String getReleasedViewUrl() {
        String path;
        AbstractPage page = this.getPage();
        return path + this.getActionParameters((path = ViewPageAction.makePrettyReleasedUrlPath(page)).contains("?") ? "&" : "?");
    }

    public static String makePrettyReleasedUrlPath(AbstractPage page) {
        Object path = page.getUrlPath();
        path = !(page instanceof BlogPost) && ((String)path).startsWith("/display/") ? ((String)path).replaceAll("/display/", "/display/public/") : "/pages/releaseview.action?pageId=" + page.getIdAsString();
        return path;
    }

    public boolean isPermitted() {
        if (!super.isPermitted()) {
            return false;
        }
        AbstractPage page = this.getPage();
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page.getLatestVersion());
        if (pageWorkflows == null) {
            return true;
        }
        this.subjectToWorkflow = true;
        if (this.approvalCheck == null) {
            boolean isPermitted;
            boolean viewDraftByDefault = this.workflowConfigurationManager.isViewDraftByDefault(page.getSpace());
            boolean canViewDraft = this.isPermitted(page);
            if (viewDraftByDefault && canViewDraft) {
                return true;
            }
            if (this.getApprovalCheck() != null && this.approvalCheck.isApproved()) {
                return true;
            }
            boolean bl = isPermitted = canViewDraft || !pageWorkflows.isRequiresFinalApproval();
            if (!isPermitted) {
                try {
                    page = (AbstractPage)page.clone();
                }
                catch (Exception e) {
                    log.error("could not clone page " + page.getDisplayTitle(), (Throwable)e);
                }
                String msg = this.getText(NO_DRAFT_VIEW_PERMITTED_ERROR_I18N);
                page.setBodyAsString(ViewPageAction.renderErrorBody(msg));
                this.setPage(page);
            }
            return true;
        }
        if (this.getApprovalCheck() == null) {
            return this.isPermitted(page);
        }
        return this.approvalCheck.isApproved() || this.isPermitted(page);
    }

    public static String renderErrorBody(String msg) {
        return "<div id=\"workflow_page_not_permitted\" class=\"aui-message error shadowed\">    <p class=\"title\">        <span class=\"aui-icon icon-error\">        </span>        <strong>" + msg + "        </strong>    </p></div>";
    }

    private boolean isPermitted(AbstractPage page) {
        ConfluenceUser user = this.getAuthenticatedUser();
        return this.workflowPermissionManager.canViewDrafts(page, user);
    }

    public boolean isViewDraft() {
        return this.draft || ViewPageCookieUtils.isViewDraft(this.getPage()) || this.workflowConfigurationManager.isViewDraftByDefault(this.getSpace());
    }

    public String execute() throws Exception {
        if (this.subjectToWorkflow) {
            this.webResourceManagerCompat.requireResource("confluence.web.resources:jquery");
            this.webResourceManagerCompat.requireResource("confluence.web.resources:ajs");
            this.webResourceManagerCompat.requireResource("com.comalatech.workflow:workflowResources");
            if (this.isViewDraft() && this.isPermitted(this.getPage())) {
                ViewPageCookieUtils.setViewDraft(this.getPage());
            } else {
                State publishedState = this.stateService.getPublishedState((ContentEntityObject)this.getPage());
                if (log.isDebugEnabled()) {
                    log.debug("user: " + this.getAuthenticatedUser() + " does not have permission to see draft page: " + this.getPage() + "   final approval is: " + this.approvalCheck + "  published state is: " + publishedState);
                }
                if (publishedState != null) {
                    return VIEW_RELEASED_RESULT;
                }
                ViewPageCookieUtils.setViewPublished(this.getPage());
            }
        }
        return super.execute();
    }

    @ParameterSafe
    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setApprovalAccessor(ApprovalAccessor approvalAccessor) {
        this.approvalAccessor = approvalAccessor;
    }

    public void setWorkflowAccessor(WorkflowAccessor workflowAccessor) {
        this.workflowAccessor = workflowAccessor;
    }

    public void setWebResourceManagerCompat(WebResourceManagerCompat webResourceManagerCompat) {
        this.webResourceManagerCompat = webResourceManagerCompat;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        if (((Object)((Object)this)).getClass().equals(ViewPageAction.class)) {
            result.setParameter("viewMode", (Object)Boolean.TRUE);
        }
        return result;
    }

    public LocaleManager getLocaleManager() {
        return PluginContainerManager.getComponent(LocaleManager.class);
    }

    public WebResourceManagerCompat getWebResourceManagerCompat() {
        return this.webResourceManagerCompat;
    }
}

