/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.InfiniteLoopWatchdog;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.tasks.manager.QueuedJobManager;
import com.comalatech.confluence.workflow.tasks.model.WorkflowActionModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowActionManager
implements WorkflowActionManager,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowActionManager.class);
    private ApplicationContext applicationContext;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final PageMessageManager pageMessageManager;
    private final EventPublisher eventPublisher;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final CacheManager cacheManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private InfiniteLoopWatchdog infiniteLoopWatchdog;
    private QueuedJobManager queuedJobManager;
    public static final String[] ACTIONS_TO_SPLIT = new String[]{"{add-restriction"};

    public DefaultWorkflowActionManager(@ComponentImport WikiStyleRenderer wikiStyleRenderer, PageMessageManager pageMessageManager, @ComponentImport EventPublisher eventPublisher, WorkflowConfigurationManager workflowConfigurationManager, @ComponentImport CacheManager cacheManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.pageMessageManager = pageMessageManager;
        this.eventPublisher = eventPublisher;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.cacheManager = cacheManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workflowsFeatureManager.isWorkflowsApp()) {
            this.infiniteLoopWatchdog = new InfiniteLoopWatchdog(this.cacheManager, this.workflowConfigurationManager);
        }
        this.queuedJobManager = (QueuedJobManager)this.applicationContext.getBean(QueuedJobManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void executeAction(ValueStore valueStore, String action, String newEventName, RenderContext renderContext) {
        String userMessage;
        if (log.isDebugEnabled()) {
            log.debug(valueStore.getPage() + " action " + action.trim().replace("\n", " "));
        }
        renderContext.addParam((Object)"com.comalatech.execute", (Object)"yes");
        renderContext.addParam((Object)"valueStore", (Object)valueStore);
        LinkedList<String> splitActions = Lists.newLinkedList();
        this.splitActionMacros(action, Lists.newArrayList(ACTIONS_TO_SPLIT), splitActions);
        boolean success = true;
        String message = null;
        for (String splitAction : splitActions) {
            message = this.wikiStyleRenderer.convertWikiToXHtml(renderContext, RenderUtils.javaScriptBlock(splitAction));
            String errorMessages = (String)renderContext.getParam((Object)"com.comalatech.log");
            if (!StringUtils.isNotBlank((CharSequence)errorMessages)) continue;
            log.error("Error Processing Workflow Trigger action page: " + valueStore.getPage() + "   trigger action: " + action + "   Error Message: " + errorMessages);
            valueStore.setErrorMessage(errorMessages);
            message = errorMessages;
            success = false;
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)(userMessage = (String)renderContext.getParam((Object)"com.comalatech.user.message")))) {
            this.pageMessageManager.setMessage(valueStore.getPage(), null, AuthenticatedUserThreadLocal.get(), userMessage, Message.MacroParamStyle.WARNING.toString(), 0L);
        }
        if (newEventName != null) {
            this.eventPublisher.publish((Object)new WorkflowCustomEvent(this, valueStore.getPage(), newEventName, success, message));
        }
    }

    @Deprecated
    protected void splitActionMacros(String actions, List<String> splitters, List<String> actionsList) {
        String[] splitActions;
        if (splitters.isEmpty()) {
            actionsList.add(actions);
            return;
        }
        String splitter = splitters.remove(0);
        for (String splitAction : splitActions = actions.split(Pattern.quote(splitter))) {
            if ((splitAction = splitAction.trim()).isEmpty()) continue;
            if (splitAction.startsWith("{")) {
                this.splitActionMacros(splitAction, new ArrayList<String>(splitters), actionsList);
                continue;
            }
            actionsList.add(splitter + splitAction);
        }
    }

    @Override
    public void doAction(Workflow workflow, ValueStore valueStore, Trigger trigger) throws WorkflowException {
        PageContext renderContext = valueStore.getPage().toPageContext();
        if (this.disableWorkflowIfExceededThreshold(valueStore.getPage())) {
            String unrenderedMessage = "Disabling workflow:  detected a loop while processing the following action on page [" + valueStore.getPage().getTitle() + "]:\n{code}" + trigger.getTrimmedAction(valueStore.getEvent()) + "{code}";
            throw new WorkflowException(unrenderedMessage);
        }
        this.executeAction(valueStore, trigger.getTrimmedAction(valueStore.getEvent()), trigger.getNewEvent(), (RenderContext)renderContext);
    }

    @Override
    public void queueAction(Workflow workflow, ValueStore valueStore, Trigger trigger) {
        if (log.isDebugEnabled()) {
            log.debug(valueStore.getPage() + " action " + trigger.getAction(null).trim().replaceAll("\n", " "));
        }
        this.queueTask(trigger.getAction(null), trigger.getNewEvent(), valueStore.getPage().getId(), AuthenticatedUserThreadLocal.getUsername(), valueStore.getPropertiesMap(), workflow.getProperties());
    }

    private void queueTask(String action, String newEventName, long pageId, String userName, Map valueStoreProperties, Map workflowProperties) {
        this.queuedJobManager.addToQueue(QueuedJobEntityAccessor.JobType.WORKFLOW_ACTION, new WorkflowActionModel(pageId, action, userName, newEventName, workflowProperties, valueStoreProperties));
    }

    @Override
    public void queueAction(AbstractPage page, String action) {
        this.queueTask(action, null, page.getId(), AuthenticatedUserThreadLocal.getUsername(), Collections.emptyMap(), Collections.emptyMap());
    }

    public boolean disableWorkflowIfExceededThreshold(AbstractPage page) {
        return this.infiniteLoopWatchdog != null && this.infiniteLoopWatchdog.hasExceededThreshold(AuthenticatedUserThreadLocal.getUsername(), page.getIdAsString());
    }
}

