/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.ParameterResolver;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer
extends WorkflowElement
implements Macroable {
    private static final Logger log = LoggerFactory.getLogger(Timer.class);
    public static final String DUE_DATE_TIMERNAME = "Due date";
    public static final DateTimeFormatter FORMATTER = TimerUtils.DEFAULT_FORMAT;
    private final String name;
    private Date instant;
    private Period period;
    private String periodReference;
    private boolean isImplicit;

    private Timer(String name) {
        super(null);
        if (!Timer.isValidName(name)) {
            throw new IllegalArgumentException("invalid timer name " + name);
        }
        this.name = name;
    }

    public Timer(String name, Date instant) {
        this(name);
        this.instant = instant;
    }

    public Timer(String name, Period period) {
        this(name);
        this.period = period;
    }

    public Timer(String name, int count, String namedPeriod) {
        this(name, TimerUtils.parsePeriod(count, namedPeriod));
    }

    public Timer(String name, String periodReference) {
        this(name);
        this.periodReference = periodReference;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setImplicit(boolean implicit) {
        this.isImplicit = implicit;
    }

    public boolean isSelectable() {
        return this.period == null;
    }

    private Date getDueDate(Period period, Date date) {
        DateTime dateTime = new DateTime(date);
        if (period != null) {
            return dateTime.plus(period).toDate();
        }
        return dateTime.plusDays(1).toDate();
    }

    public Date getDueDate(ParameterResolver parameterResolver, AbstractPage page) {
        String strPeriod;
        if (this.instant != null) {
            return this.instant;
        }
        if (this.period != null) {
            return this.getDueDate(this.period, new Date());
        }
        if (this.periodReference != null && parameterResolver != null && StringUtils.isNotBlank((CharSequence)(strPeriod = parameterResolver.getParameterValue(page, this.periodReference)))) {
            try {
                Period dueDatePeriod = TimerUtils.parsePeriod(strPeriod);
                return this.getDueDate(dueDatePeriod, new Date());
            }
            catch (Exception e) {
                log.error("Error processing date {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return new Date();
    }

    public String getDueDateAsString(AbstractPage page) {
        return FORMATTER.print(new DateTime(this.getDueDate(null, page)));
    }

    public static boolean isValidName(String name) {
        for (char c : name.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == ' ') continue;
            return false;
        }
        return true;
    }

    public TimerUtils.SimpleDuration getDuration() {
        return TimerUtils.periodToDuration(this.period);
    }

    @Override
    public SerializableMacro toMacro() {
        if (this.isImplicit()) {
            return null;
        }
        SerializableMacro macro = new SerializableMacro("timer");
        macro.addParameter(this.name);
        if (this.period == null) {
            macro.addParameter("period", (Object)TimerUtils.periodToString(this.period));
        }
        return macro;
    }

    public String toString() {
        return "Timer{name='" + this.name + "'" + (this.period != null ? ", period=" + TimerUtils.periodToString(this.period) : "periodReference=" + this.periodReference) + ", isImplicit=" + this.isImplicit + "}";
    }

    public String getName() {
        return this.name;
    }

    public void setInstant(Date instant) {
        this.instant = instant;
    }

    public Date getInstant() {
        return this.instant;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriodReference(String periodReference) {
        this.periodReference = periodReference;
    }

    public String getPeriodReference() {
        return this.periodReference;
    }
}

