/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.service;

import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfTemplateExportIntegrationServiceAccessor;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfTemplateExportIntegrationServiceHolder;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.mapper.PdfTemplateMapper;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfTemplateExportIntegrationModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.service.PdfTemplateExportIntegrationService;
import com.k15t.scroll.exporter.api.pdf.PdfTemplateService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class DefaultPdfTemplateExportIntegrationService
implements PdfTemplateExportIntegrationService {
    private final PdfTemplateExportIntegrationServiceAccessor pdfTemplateExportIntegrationServiceAccessor;
    private static final String DEFAULT_TEMPLATE_ID = "com.k15t.scroll.pdf.default-template-documentation";

    public DefaultPdfTemplateExportIntegrationService(PdfTemplateExportIntegrationServiceAccessor pdfTemplateExportIntegrationServiceAccessor) {
        this.pdfTemplateExportIntegrationServiceAccessor = pdfTemplateExportIntegrationServiceAccessor;
    }

    @Override
    public List<PdfTemplateExportIntegrationModel> retrieveAllTemplates(String spaceKey) throws IOException {
        PdfTemplateService pdfTemplateService = (PdfTemplateService)this.getPdfTemplateService().getPdfTemplateService();
        List pdfTemplateList = pdfTemplateService.getTemplates(spaceKey);
        return PdfTemplateMapper.retrievedTemplatesToModel(pdfTemplateList);
    }

    private PdfTemplateExportIntegrationServiceHolder getPdfTemplateService() {
        return this.pdfTemplateExportIntegrationServiceAccessor.getPdfTemplateExportIntegrationServiceHolder();
    }

    public String getTemplateId(String templateName, String spaceKey) throws IOException {
        return this.getTemplateByName(templateName, spaceKey);
    }

    public String getTemplateByName(String templateName, String spaceKey) throws IOException {
        List<PdfTemplateExportIntegrationModel> retrievedTemplates = this.retrieveAllTemplates(spaceKey);
        Optional<String> existingTemplateId = retrievedTemplates.stream().filter(PdfTemplateExportIntegrationModel2 -> PdfTemplateExportIntegrationModel2.getTemplateName().equals(templateName)).map(PdfTemplateExportIntegrationModel::getTemplateId).findFirst();
        return existingTemplateId.orElseGet(() -> this.getTemplateById(retrievedTemplates, templateName));
    }

    private String getTemplateById(List<PdfTemplateExportIntegrationModel> retrievedTemplates, String templateName) {
        Optional<String> existingTemplateId = retrievedTemplates.stream().filter(PdfTemplateExportIntegrationModel2 -> PdfTemplateExportIntegrationModel2.getTemplateId().equals(templateName)).map(PdfTemplateExportIntegrationModel::getTemplateId).findFirst();
        return existingTemplateId.orElse(DEFAULT_TEMPLATE_ID);
    }
}

