/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.handler;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportErrorEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportSuccessEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.manager.PdfManager;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportActionModel;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.tasks.handler.AbstractQueuedJobHandler;
import com.comalatech.workflow.model.State;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PdfExportActionHandlerImpl
extends AbstractQueuedJobHandler<PdfExportActionModel> {
    private static final Logger log = LoggerFactory.getLogger(PdfExportActionHandlerImpl.class);
    private final PdfManager pdfManager;
    private final PageManager pageManager;
    private final EventPublisher eventPublisher;
    private final StateAccessor stateAccessor;
    private final ComalaI18nBean comalaI18nBean;

    public PdfExportActionHandlerImpl(PdfManager pdfManager, @ComponentImport PageManager pageManager, @ComponentImport UserAccessor userAccessor, @ComponentImport EventPublisher eventPublisher, StateAccessor stateAccessor, ComalaI18nBean comalaI18nBean) {
        this.pdfManager = pdfManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.stateAccessor = stateAccessor;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public void handle(PdfExportActionModel model) {
        if (log.isDebugEnabled()) {
            log.debug("Processing pdf export action on content with id: " + model.getContentId());
        }
        AbstractPage abstractPage = null;
        if (model.getContentId() != null) {
            abstractPage = this.pageManager.getAbstractPage(model.getContentId().longValue());
        }
        if (abstractPage == null) {
            String errorMsg = this.comalaI18nBean.getText("com.comalatech.macro.k15t.error.pdf-export-page-not-found");
            this.eventPublisher.publish((Object)new PdfExportErrorEvent((Object)this, null, null, errorMsg));
            log.error("There is no page with the following id: " + model.getContentId());
            return;
        }
        PageState pageState = this.stateAccessor.getLatestState(abstractPage);
        try {
            Attachment attachedPdf = StringUtils.isBlank((CharSequence)model.getTemplateId()) ? this.pdfManager.attachCurrentVersionPDF(abstractPage) : this.pdfManager.attachCurrentVersionPDF(abstractPage, model);
            this.eventPublisher.publish((Object)new PdfExportSuccessEvent(this, abstractPage, pageState, attachedPdf));
        }
        catch (Exception e) {
            log.error("There was an error processing pdf export action on content with id: " + model.getContentId(), (Throwable)e);
            this.eventPublisher.publish((Object)new PdfExportErrorEvent((Object)this, abstractPage, (State)pageState, e));
        }
    }
}

