/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.metadata.atlassian;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroInstance;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroReport;
import com.atlassian.confluence.plugins.pageproperties.api.model.PageProperty;
import com.atlassian.confluence.plugins.pageproperties.api.service.PagePropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.metadata.MetadataAccessor;
import com.comalatech.confluence.metadata.atlassian.PagePropertiesRenderingContext;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlassianMetadataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(AtlassianMetadataAccessor.class);
    private final PagePropertiesService pagePropertiesService;
    private final Renderer renderer;

    public AtlassianMetadataAccessor(@ComponentImport PagePropertiesService pagePropertiesService, @ComponentImport Renderer renderer) {
        this.pagePropertiesService = pagePropertiesService;
        this.renderer = renderer;
    }

    @Override
    public String getValue(ContentEntityObject ceo, String value, int loopIterations) {
        if (loopIterations < PagePropertiesRenderingContext.MAX_NUM_ITERATIONS) {
            String valueFromPageProperties = this.getValueFromPageProperties(ceo, value, loopIterations);
            if (null != valueFromPageProperties) {
                return valueFromPageProperties;
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Skipping metadata: retrieval :" + value + ", the max number of iterations " + PagePropertiesRenderingContext.MAX_NUM_ITERATIONS + " was reached or the page property name matched the name of the property being retrieved");
        }
        return "";
    }

    private String getValueFromPageProperties(ContentEntityObject ceo, String value, int loopIterations) {
        String output = null;
        try {
            HashMap allPropertiesMap = new HashMap();
            PagePropertiesMacroReport report = this.pagePropertiesService.getReportFromContent(ceo);
            for (PagePropertiesMacroInstance instance : report.getAllMacroInstances()) {
                allPropertiesMap.putAll(instance.getPagePropertyReportRow());
            }
            PageProperty result = (PageProperty)allPropertiesMap.get(value);
            if (result != null && this.isHtml(output = this.renderer.render(result.getDetailStorageFormat().trim(), (ConversionContext)new DefaultConversionContext((RenderContext)new PagePropertiesRenderingContext(ceo, value, loopIterations))))) {
                output = this.getInnerTextFromHtml(output);
            }
        }
        catch (Exception e) {
            log.error("error parsing " + ceo, (Throwable)e);
        }
        return output;
    }

    private boolean isHtml(String string) {
        return Pattern.compile("<(\"[^\"]*\"|'[^']*'|[^'\">])*>").matcher(string).find();
    }

    private String getInnerTextFromHtml(String htmlString) {
        Element rootElement = Jsoup.parse("<div>" + htmlString + "</div>").selectFirst("div");
        String users = this.makeUsers(rootElement);
        if (null != users) {
            return users;
        }
        return this.getInnerHtml(rootElement);
    }

    private String makeUsers(Element element) {
        if (null == element) {
            return null;
        }
        Elements users = element.getElementsByAttribute("data-username");
        if (users.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Element user : users) {
            String userName = user.attr("data-username");
            if (!StringUtils.isNotBlank((CharSequence)userName)) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append(userName);
            first = false;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private String getInnerHtml(Element element) {
        if (null == element) {
            return "";
        }
        return StringEscapeUtils.escapeHtml4((String)element.text());
    }
}

