/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.task;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowStatesInitializationEventImpl;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetStateTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(SetStateTask.class);
    private final UserAccessor userAccessor;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;
    private final StateManager stateManager;
    private final ApprovalManager approvalManager;
    private final PageManager pageManager;
    private final WorkflowAccessor workflowAccessor;
    private final StateAccessor stateAccessor;
    private final SpaceManager spaceManager;
    private final AccessModeService accessModeService;
    private final DarkFeatureManager darkFeatureManager;
    private final ComalaI18nBean comalaI18nBean;
    private final boolean override;
    private final String stateName;
    private String errorMessage = null;
    private String userName;
    private String spaceKey;
    private String workflowName;
    private Set<Long> pageIds;
    private int updated = 0;
    private int errors = 0;
    private int maxErrorsAllowed = 0;
    public static final int BATCH_SIZE = 25;

    public SetStateTask(PageManager pageManager, UserAccessor userAccessor, EventPublisher eventPublisher, StateManager stateManager, ApprovalManager approvalManager, WorkflowAccessor workflowAccessor, StateAccessor stateAccessor, SpaceManager spaceManager, TransactionTemplate transactionTemplate, boolean override, String stateName, String spaceKey, AccessModeService accessModeService, DarkFeatureManager darkFeatureManager, ComalaI18nBean comalaI18nBean) {
        this(pageManager, userAccessor, eventPublisher, stateManager, approvalManager, workflowAccessor, stateAccessor, spaceManager, transactionTemplate, override, stateName, accessModeService, darkFeatureManager, comalaI18nBean);
        this.spaceKey = spaceKey;
    }

    public SetStateTask(PageManager pageManager, UserAccessor userAccessor, EventPublisher eventPublisher, StateManager stateManager, ApprovalManager approvalManager, WorkflowAccessor workflowAccessor, StateAccessor stateAccessor, SpaceManager spaceManager, TransactionTemplate transactionTemplate, String workflowName, boolean override, String stateName, String spaceKey, AccessModeService accessModeService, DarkFeatureManager darkFeatureManager, ComalaI18nBean comalaI18nBean) {
        this(pageManager, userAccessor, eventPublisher, stateManager, approvalManager, workflowAccessor, stateAccessor, spaceManager, transactionTemplate, override, stateName, accessModeService, darkFeatureManager, comalaI18nBean);
        this.spaceKey = spaceKey;
        this.workflowName = workflowName;
    }

    public SetStateTask(PageManager pageManager, UserAccessor userAccessor, EventPublisher eventPublisher, StateManager stateManager, ApprovalManager approvalManager, WorkflowAccessor workflowAccessor, StateAccessor stateAccessor, SpaceManager spaceManager, TransactionTemplate transactionTemplate, String stateName, AccessModeService accessModeService, DarkFeatureManager darkFeatureManager, ComalaI18nBean comalaI18nBean, Long ... pageIds) {
        this(pageManager, userAccessor, eventPublisher, stateManager, approvalManager, workflowAccessor, stateAccessor, spaceManager, transactionTemplate, true, stateName, accessModeService, darkFeatureManager, comalaI18nBean);
        this.pageIds = new HashSet<Long>();
        this.pageIds.addAll(Arrays.asList(pageIds));
    }

    private SetStateTask(PageManager pageManager, UserAccessor userAccessor, EventPublisher eventPublisher, StateManager stateManager, ApprovalManager approvalManager, WorkflowAccessor workflowAccessor, StateAccessor stateAccessor, SpaceManager spaceManager, TransactionTemplate transactionTemplate, boolean override, String stateName, AccessModeService accessModeService, DarkFeatureManager darkFeatureManager, ComalaI18nBean comalaI18nBean) {
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.stateManager = stateManager;
        this.approvalManager = approvalManager;
        this.workflowAccessor = workflowAccessor;
        this.stateAccessor = stateAccessor;
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
        this.override = override;
        this.stateName = stateName;
        this.userName = AuthenticatedUserThreadLocal.getUsername();
        this.accessModeService = accessModeService;
        this.darkFeatureManager = darkFeatureManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        ConfluenceUser user = this.userAccessor.getUserByName(this.userName);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
            List pagesAndBlogs = (List)this.transactionTemplate.execute((TransactionCallback)new GetPagesToInitialise(this.spaceKey, this.pageIds));
            int totalBatches = pagesAndBlogs.size() / 25;
            totalBatches += pagesAndBlogs.size() % 25 > 0 ? 1 : 0;
            int currentBatch = 1;
            this.progress.setCurrentCount(0);
            this.progress.setTotalObjects(pagesAndBlogs.size());
            this.maxErrorsAllowed = this.getMaxNumberOfErrors(pagesAndBlogs.size());
            for (List<Long> list : Lists.partition(pagesAndBlogs, 25)) {
                if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
                    throw new ReadOnlyException(this.comalaI18nBean.getText("com.comalatech.readonlymode.long.running.task.error"));
                }
                SetStateTransactionCallback tc = new SetStateTransactionCallback(list);
                this.transactionTemplate.execute((TransactionCallback)tc);
                this.progress.setPercentage(currentBatch, totalBatches);
                ++currentBatch;
                if (log.isDebugEnabled()) {
                    log.debug("Batch " + currentBatch + " out of " + totalBatches + "successfully completed");
                }
                Thread.sleep(8000L);
            }
            if (this.errors == 0) {
                this.progress.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.completed.ok", new Object[]{pagesAndBlogs.size(), this.updated}));
            } else {
                this.progress.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.completed.error", new Object[]{pagesAndBlogs.size(), this.errors}));
            }
            if (log.isDebugEnabled()) {
                log.debug("Workflow Content Properties population task successfully completed");
            }
            this.progress.setCurrentCount(pagesAndBlogs.size());
            this.progress.setCompletedSuccessfully(true);
            if (this.spaceKey != null) {
                SpaceWorkflowStatesInitializationEventImpl event = new SpaceWorkflowStatesInitializationEventImpl(this.getSpace(), this.stateName, this.override);
                this.eventPublisher.publish((Object)event);
            }
        }
        catch (Exception e) {
            this.progress.setPercentage(100);
            if (e.getMessage() != null) {
                this.progress.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.initialize.error.exception", new Object[]{e.getMessage()}));
                if (log.isDebugEnabled()) {
                    log.debug(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.initialize.error.exception", new Object[]{e.getMessage()}));
                }
            } else {
                this.progress.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.initialize.error"));
                if (log.isDebugEnabled()) {
                    log.debug(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.initialize.error"));
                }
            }
            this.progress.setCompletedSuccessfully(false);
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
        }
    }

    public boolean setState(List<Long> pageIds) {
        for (Long pageId : pageIds) {
            block5: {
                AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
                this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
                try {
                    StateChangeReason reason;
                    StatesContainer statesContainer;
                    State state;
                    PageWorkflows pageWorkflows;
                    Workflow workflow;
                    PageState pageState = this.stateAccessor.getLatestState(page);
                    if (pageState != null && (!this.override || pageState.getState().equals(this.stateName)) || (workflow = (pageWorkflows = this.workflowAccessor.getWorkflows(page)) != null ? pageWorkflows.getFirstWorkflowWithStates() : null) == null || StringUtils.isNotBlank((CharSequence)this.workflowName) && !this.workflowName.equals(workflow.getName()) || (state = (statesContainer = pageWorkflows.getStatesContainer()).getState(this.stateName)) == null) continue;
                    ApprovalCheck check = null;
                    StateChangeReason stateChangeReason = reason = this.spaceKey != null ? StateChangeReason.SPACE_INITIALISE : null;
                    if (state.isFinalState()) {
                        check = reason != null && this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.newactivity.listener.disabled").orElse(true) == false ? this.approvalManager.approvePage(page, this.stateManager.getOrCreatePreceedingApproval(state), true, "", AuthenticatedUserThreadLocal.get(), true, true, true, true, true) : this.approvalManager.approvePage(page, this.stateManager.getOrCreatePreceedingApproval(state), true, "", AuthenticatedUserThreadLocal.get(), true, true, true, true);
                    }
                    this.stateManager.setState(pageWorkflows.getValueStore(), state, true, AuthenticatedUserThreadLocal.get(), "", null, pageWorkflows.getReadAck(), reason);
                    if (check != null) {
                        this.approvalManager.markFinalApproval(page, check);
                    }
                    ++this.updated;
                }
                catch (Exception e) {
                    ++this.errors;
                    log.error("", (Throwable)e);
                    if (this.errors <= this.maxErrorsAllowed) break block5;
                    String error = this.comalaI18nBean.getText("com.comalatech.workflow.state.init.error", new Object[]{this.errors, this.updated});
                    log.error(error);
                    this.setErrorMessage(error);
                    this.progress.setStatus(this.errorMessage);
                    this.progress.setPercentage(100);
                    this.progress.setCompletedSuccessfully(false);
                    break;
                }
            }
            this.progress.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.state.init.status", new Object[]{this.progress.getCurrentCount(), this.progress.getTotal(), this.updated, this.errors}));
        }
        return true;
    }

    private List<AbstractPage> getAllPages(Set<Long> pageIds, String spaceKey) {
        ArrayList<AbstractPage> pagesAndBlogs = new ArrayList<AbstractPage>();
        if (spaceKey != null) {
            List pages = this.pageManager.getPages(this.getSpace(), true);
            List blogs = this.pageManager.getBlogPosts(this.getSpace(), true);
            pagesAndBlogs.addAll(pages);
            pagesAndBlogs.addAll(blogs);
        } else {
            for (Long pageId : pageIds) {
                AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
                if (page == null) continue;
                pagesAndBlogs.add(page);
            }
        }
        return pagesAndBlogs;
    }

    private Space getSpace() {
        return this.spaceManager.getSpace(this.spaceKey);
    }

    private int getMaxNumberOfErrors(int numberOfPages) {
        int maxErrorsAllowed;
        int n = maxErrorsAllowed = numberOfPages > 50 ? numberOfPages / 10 : 20;
        if (maxErrorsAllowed > 100) {
            maxErrorsAllowed = 100;
        }
        return maxErrorsAllowed;
    }

    public String getName() {
        return this.comalaI18nBean.getText("com.comalatech.workflow.state.init.task-name");
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private class SetStateTransactionCallback
    implements TransactionCallback {
        private final List<Long> batchPageIds;

        SetStateTransactionCallback(List<Long> batchPageIds) {
            this.batchPageIds = batchPageIds;
        }

        public Object doInTransaction() {
            SetStateTask.this.setState(this.batchPageIds);
            return null;
        }
    }

    private class GetPagesToInitialise
    implements TransactionCallback<List<Long>> {
        private final String spaceKey;
        private final Set<Long> pageIds;

        GetPagesToInitialise(String spaceKey, Set<Long> pageIds) {
            this.spaceKey = spaceKey;
            this.pageIds = pageIds;
        }

        public List<Long> doInTransaction() {
            ArrayList<Long> allPageIds = new ArrayList<Long>();
            List<AbstractPage> allPages = SetStateTask.this.getAllPages(this.pageIds, this.spaceKey);
            for (AbstractPage page : allPages) {
                allPageIds.add(page.getId());
            }
            return allPageIds;
        }
    }
}

