/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="workflowTemplateManager")
@ExportAsService
public class DefaultWorkflowTemplateManager
implements WorkflowTemplateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowTemplateManager.class);
    private final WorkflowContainerManager workflowContainerManager;
    private final LinkedTemplateManager linkedTemplateManager;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultWorkflowTemplateManager(WorkflowContainerManager workflowContainerManager, LinkedTemplateManager linkedTemplateManager, ComalaI18nBean comalaI18nBean) {
        this.workflowContainerManager = workflowContainerManager;
        this.linkedTemplateManager = linkedTemplateManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getWorkflowTemplates() {
        return this.convertWorkflowList(this.workflowContainerManager.getAvailableWorkflowTemplates(null));
    }

    public List<com.comalatech.workflow.model.Workflow> getAllWorkflowTemplates() {
        return this.convertWorkflowList(this.workflowContainerManager.getWorkflowTemplates(null));
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getWorkflowTemplates(Space space) {
        return this.convertWorkflowList(this.workflowContainerManager.getWorkflowTemplates(space));
    }

    @Override
    public void addWorkflowTemplate(Space space, String workflowMarkup) throws WorkflowException {
        Workflow workflow = this.workflowContainerManager.renderWorkflow(workflowMarkup);
        this.addWorkflowTemplate(space, workflow);
    }

    public void addWorkflowTemplate(Space space, Workflow workflow) throws WorkflowException {
        workflow.validateWorkflow();
        if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
        }
        if (StringUtils.isBlank((CharSequence)workflow.getName())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.workflow.name.empty");
        }
        Workflow existingTemplate = this.workflowContainerManager.getWorkflowTemplate(space != null ? space.getKey() : null, workflow.getName());
        if (existingTemplate != null) {
            throw new WorkflowException(this.comalaI18nBean.getText("cw.spaceadmin.addWorkflowAlreadyExist"));
        }
        this.workflowContainerManager.saveWorkflowTemplate(space != null ? space.getKey() : null, workflow, false, null);
    }

    @Override
    public void removeWorkflowTemplate(Space space, String workflowName) {
        if (space == null) {
            this.removeGlobalWorkflowTemplate(workflowName);
        } else {
            this.workflowContainerManager.removeWorkflowTemplate(space.getKey(), workflowName);
        }
    }

    public void removeGlobalWorkflowTemplate(String workflowName) {
        this.workflowContainerManager.removeWorkflowTemplate(null, workflowName);
        List<String> linkedSpaceKeys = this.linkedTemplateManager.getLinkedSpaces(workflowName);
        for (String spaceKey : linkedSpaceKeys) {
            this.linkedTemplateManager.removeTemplateLink(spaceKey, workflowName);
        }
        List<String> linkedSpaceLabels = this.linkedTemplateManager.getLinkedSpaceLabels(workflowName);
        for (String spaceLabel : linkedSpaceLabels) {
            this.linkedTemplateManager.removeSpaceLabelLink(spaceLabel, workflowName);
        }
    }

    @Override
    public void activateGlobalTemplate(String workflowName) throws WorkflowException {
        this.toggleWorkflowActive(workflowName, true);
    }

    @Override
    public void deactivateGlobalTemplate(String workflowName) throws WorkflowException {
        this.toggleWorkflowActive(workflowName, false);
    }

    @Override
    public void copyGlobalTemplate(String workflowName) {
        Workflow workflow = null;
        try {
            workflow = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
        }
        catch (com.comalatech.confluence.workflow.WorkflowException e) {
            log.info("global workflow template not found: " + workflowName);
        }
        if (workflow != null) {
            this.workflowContainerManager.copyWorkflowTemplate(null, workflow);
        }
    }

    protected void toggleWorkflowActive(String workflowName, boolean active) throws WorkflowException {
        Workflow workflow = null;
        try {
            workflow = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
        }
        catch (com.comalatech.confluence.workflow.WorkflowException e) {
            log.info("global workflow template not found: " + workflowName);
        }
        if (workflow != null) {
            if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                throw new WorkflowException(workflow.getErrorMessage());
            }
            this.workflowContainerManager.setGlobalWorkflowActive(null, workflowName, active);
        }
    }

    protected List<com.comalatech.workflow.model.Workflow> convertWorkflowList(List<Workflow> list) {
        return new ArrayList<com.comalatech.workflow.model.Workflow>(list);
    }
}

