/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.accessor;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpaceUpgradeAccessor;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.UpgradeTaskRecord;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpaceUpgradeAccessorImpl
implements SpaceUpgradeAccessor {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeAccessorImpl.class);
    private final ComalaPropertiesSetManager comalaPropertiesSetManager;
    private static final String UPGRADE_PRE_CHECK_KEY = "com.comalatech.upgrade.pre-check";
    private final ObjectMapper objectMapper;

    public SpaceUpgradeAccessorImpl(ComalaPropertiesSetManager comalaPropertiesSetManager) {
        this.comalaPropertiesSetManager = comalaPropertiesSetManager;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public UpgradeTaskRecord getSpaceUpgradeRecord(Space space) {
        UpgradeTaskRecord upgradeTaskRecord = null;
        if (space != null) {
            if (space.getDescription() == null) {
                log.error("There is no space description object for space: " + space.getKey());
            } else {
                String preCheckStr = this.comalaPropertiesSetManager.getTextProperty((ContentEntityObject)space.getDescription(), UPGRADE_PRE_CHECK_KEY);
                if (preCheckStr != null) {
                    upgradeTaskRecord = this.parsePreCheckContentProperty(preCheckStr);
                }
            }
        }
        return upgradeTaskRecord;
    }

    @Override
    public UpgradeTaskRecord saveSpaceUpgradeRecord(Space space, UpgradeTaskRecord upgradeTaskRecord) {
        if (space != null) {
            try {
                this.comalaPropertiesSetManager.setTextProperty((ContentEntityObject)space.getDescription(), UPGRADE_PRE_CHECK_KEY, this.objectMapper.writeValueAsString(upgradeTaskRecord));
            }
            catch (IOException e) {
                log.error("Error saving pre-check key for space:" + space.getKey());
                return null;
            }
            return upgradeTaskRecord;
        }
        return null;
    }

    private UpgradeTaskRecord parsePreCheckContentProperty(String preCheckProperty) {
        try {
            return this.objectMapper.readValue(preCheckProperty, UpgradeTaskRecord.class);
        }
        catch (IOException e) {
            log.error("Error parsing pre-check key:" + preCheckProperty);
            return null;
        }
    }
}

