/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.mapper;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ApprovalCheckMapper {
    private final UserAccessor userAccessor;

    public ApprovalCheckMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public ApprovalCheck toApprovalCheck(Activity activity) {
        if (Objects.isNull(activity)) {
            return null;
        }
        ApprovalCheck approvalCheck = new ApprovalCheck();
        approvalCheck.setVersion(activity.getTarget().getTargetVersion());
        ActionDetails details = activity.getAction().getActionDetails();
        if (details != null) {
            String approvers;
            approvalCheck.setName(details.getDetailValue(ActionDetailType.APPROVAL_NAME));
            String requiredApprovers = details.getDetailValue(ActionDetailType.APPROVAL_REQUIRED_APPROVERS);
            if (requiredApprovers != null) {
                ArrayList requiredUsers = new ArrayList();
                this.toConfluenceUsers(requiredApprovers).forEach(user -> requiredUsers.add(user.getName()));
                approvalCheck.setRequiredApprovers(requiredUsers.toArray(new String[0]));
            }
            ArrayList users = new ArrayList();
            String rejectors = details.getDetailValue(ActionDetailType.APPROVAL_REJECTORS);
            if (rejectors != null) {
                this.toConfluenceUsers(rejectors).forEach(user -> users.add(this.toApprover((ConfluenceUser)user, false)));
                approvalCheck.setApprovers(users.toArray(new Approver[0]));
            }
            if ((approvers = details.getDetailValue(ActionDetailType.APPROVAL_APPROVERS)) != null) {
                this.toConfluenceUsers(approvers).forEach(user -> users.add(this.toApprover((ConfluenceUser)user, true)));
                approvalCheck.setApprovers(users.toArray(new Approver[0]));
            }
            String comment = details.getDetailValue(ActionDetailType.APPROVAL_COMMENT);
            if (approvalCheck.getLastApprover() != null) {
                if (comment != null) {
                    approvalCheck.getLastApprover().setComment(comment);
                }
                approvalCheck.getLastApprover().setDate(new Date(activity.getMoment()));
            }
        }
        approvalCheck.setMinimumApproversRequired(approvalCheck.getApprovers().length);
        return approvalCheck;
    }

    private List<ConfluenceUser> toConfluenceUsers(String jsonApprovers) {
        String[] approversUserKeys;
        ArrayList<ConfluenceUser> result = new ArrayList<ConfluenceUser>();
        for (String approverUserKey : approversUserKeys = new Gson().fromJson(jsonApprovers, String[].class)) {
            UserKey userKey = new UserKey(approverUserKey);
            ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
            if (user == null) continue;
            result.add(user);
        }
        return result;
    }

    private Approver toApprover(ConfluenceUser user, boolean approved) {
        Approver approver = new Approver();
        approver.setUser(user.getName());
        approver.setApproved(approved);
        return approver;
    }
}

