/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.validator;

import com.comalatech.confluence.documentActivity.rest.model.DocumentActivityReportRequest;
import com.comalatech.confluence.documentActivity.rest.model.DocumentActivityRequest;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryScope;
import java.util.Objects;

public class RequestValidator {
    public void validateTarget(DocumentActivityReportRequest query) {
        if (query == null || query.getFilters() == null) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory scope");
        }
        RequestValidator.validateBasicFilters(query.getFilters().getScope());
    }

    public void validateTarget(DocumentActivityRequest query) {
        if (query == null || query.getFilters() == null) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory scope");
        }
        RequestValidator.validateBasicFilters(query.getFilters().getScope());
    }

    private static void validateBasicFilters(DocumentActivityQueryScope scope) {
        if (Objects.isNull(scope) || Objects.isNull(scope.getPageIds()) && Objects.isNull(scope.getSpaceKeys())) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory scope");
        }
    }

    public void validatePages(DocumentActivityQueryScope scope) {
        if (Objects.isNull(scope.getPageIds())) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory pageIds");
        }
    }

    public void validateSpaces(DocumentActivityQueryScope scope) {
        if (Objects.isNull(scope.getSpaceKeys())) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory spaceKeys");
        }
    }
}

