/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskAssignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskAssignEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;
import org.apache.commons.lang3.StringUtils;

public class TaskAssignmentMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskAssignmentMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskAssignEvent) {
            PageTaskAssignEvent pageTaskAssignEvent = (PageTaskAssignEvent)event;
            return this.buildActivity((AbstractPage)pageTaskAssignEvent.getPage(), (PageState)pageTaskAssignEvent.getState(), (PageTask)pageTaskAssignEvent.getTask(), pageTaskAssignEvent.getAssignment());
        }
        if (event instanceof BlogPostTaskAssignEvent) {
            BlogPostTaskAssignEvent blogPostTaskAssignEvent = (BlogPostTaskAssignEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskAssignEvent.getBlogPost(), (PageState)blogPostTaskAssignEvent.getState(), (PageTask)blogPostTaskAssignEvent.getTask(), blogPostTaskAssignEvent.getAssignment());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask, Assignment assignment) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(assignment.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetailType.TASK_NAME, pageTask.getName());
        String comment = assignment.getComment();
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            details.addDetail(ActionDetailType.TASK_COMMENT, comment);
        }
        Actor assignedUser = this.actorUtils.buildActor(assignment.getAssignee());
        details.addDetail(ActionDetailType.TASK_USER_ASSIGNED, assignedUser.getId(), null, assignedUser);
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_ASSIGNMENT), actor, details);
        return new Activity(TaskAssignmentMapper.buildTarget((ContentEntityObject)abstractPage), assignment.getDate().getTime(), action);
    }
}

