/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ValidatePageActivity;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ValidateActivityUseCase
implements ValidatePageActivity {
    private static final Logger log = LoggerFactory.getLogger(ValidateActivityUseCase.class);
    private final ActivityManager activityManager;
    private final PageActivityCsvService pageActivityCsvService;
    private final PageActivityCsvService docActivityCSVService;
    private final ComalaI18nBean comalaI18nBean;

    public ValidateActivityUseCase(ActivityManager activityManager, @Qualifier(value="pageActivityCsvService") PageActivityCsvService pageActivityCsvService, @Qualifier(value="docActivityCsvService") PageActivityCsvService docActivityCSVService, ComalaI18nBean comalaI18nBean) {
        this.activityManager = activityManager;
        this.pageActivityCsvService = pageActivityCsvService;
        this.docActivityCSVService = docActivityCSVService;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public boolean validateActivity(AbstractPage page, List<Activity> activities, boolean onlyCurrentActivity) {
        boolean areSameEntries;
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReportForMigration(page, exportOptions);
        String currentReportEntries = onlyCurrentActivity ? this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries.size() > 0 ? activityReportEntries.subList(0, 1) : activityReportEntries, page, PageActivityCsvConfig.builder().skipOtherVersion(true).locale(Locale.UK).build()) : this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, page, PageActivityCsvConfig.builder().skipOtherVersion(true).locale(Locale.UK).build());
        String newReportModelEntries = this.docActivityCSVService.getPageActivityFileContent(activities, page, PageActivityCsvConfig.builder().skipOtherVersion(true).locale(Locale.UK).build());
        String initialisationOverride = this.getStateInitialisationOverrideText();
        String adminOverride = this.getStateAdminOverrideText();
        if (currentReportEntries.contains(initialisationOverride)) {
            currentReportEntries = currentReportEntries.replace(initialisationOverride, "");
        }
        if (currentReportEntries.contains(adminOverride)) {
            currentReportEntries = currentReportEntries.replace(adminOverride, "");
        }
        if (!(areSameEntries = Objects.equals(currentReportEntries, newReportModelEntries))) {
            String diff = StringUtils.difference((String)currentReportEntries, (String)newReportModelEntries);
            log.info("Page " + page.getTitle() + " has differences between current report entries and new activity domain entries: " + diff);
            int index = StringUtils.indexOfDifference((CharSequence)currentReportEntries, (CharSequence)newReportModelEntries);
            if (currentReportEntries != null) {
                log.info("Both reports have this content in common: " + currentReportEntries.substring(0, index));
            }
        }
        return areSameEntries;
    }

    private String getStateInitialisationOverrideText() {
        return " (" + this.comalaI18nBean.getText("com.comalatech.workflows.stateChangeReason.spaceInitialise") + ")";
    }

    private String getStateAdminOverrideText() {
        return " (" + this.comalaI18nBean.getText("com.comalatech.workflows.stateChangeReason.adminOverride") + ")";
    }
}

