/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivity;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ApprovalsMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.TransitionsMapper;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.ipc.api.DefaultStateService;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.workflow.StateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GenerateActivityUseCase
implements GeneratePageActivity {
    private static final Logger log = LoggerFactory.getLogger(GenerateActivityUseCase.class);
    private final StateService stateService;
    private final ApprovalAccessor approvalAccessor;
    private final TransitionsMapper transitionsMapper;
    private final ApprovalsMapper approvalsMapper;

    public GenerateActivityUseCase(StateService stateService, ApprovalAccessor approvalAccessor, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, WorkflowUserAccessor workflowUserAccessor) {
        this.stateService = stateService;
        this.approvalAccessor = approvalAccessor;
        ActorUtils actorUtils = new ActorUtils(userAccessor, workflowUserAccessor);
        this.transitionsMapper = new TransitionsMapper(pageManager, actorUtils);
        this.approvalsMapper = new ApprovalsMapper(pageManager, actorUtils);
    }

    @Override
    public List<Activity> generateActivity(AbstractPage page) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        List<PageState> states = ((DefaultStateService)this.stateService).getStates((ContentEntityObject)page);
        List<ApprovalCheck> approvalChecks = Arrays.asList(this.approvalAccessor.getApprovalChecks(page));
        states.forEach(state -> {
            activities.add(this.transitionsMapper.buildTransitionActivity((PageState)state));
            approvalChecks.stream().filter(approvalCheck -> approvalCheck.getStateId() == state.getId()).forEach(approvalCheck -> {
                List<Approver> approvers = Arrays.asList(approvalCheck.getApprovers());
                approvers.forEach(approver -> activities.add(this.approvalsMapper.buildApprovalOrRejectionActivity((PageState)state, (ApprovalCheck)approvalCheck, (Approver)approver)));
            });
        });
        activities.sort(Comparator.comparingLong(Activity::getMoment));
        return activities;
    }

    @Override
    public List<Activity> generateCurrentActivity(AbstractPage page) {
        PageState currentState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        if (currentState != null) {
            if (currentState.getPage() != null) {
                Activity activity = this.transitionsMapper.buildTransitionActivity(currentState);
                return Collections.singletonList(activity);
            }
            log.error("Page" + page.getTitle() + " has not been state initialised");
        }
        log.debug("No activities generated for page " + page.getTitle());
        return Collections.emptyList();
    }
}

