/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.tasks;

import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskStatus;
import com.comalatech.confluence.cloud.migration.service.DefaultCloudMigrationContentService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachActivityTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityTask.class);
    private final String spaceKey;
    private final AttachActivityTaskRecord attachActivityTaskRecord;
    private final DefaultCloudMigrationContentService defaultCloudMigrationContentService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final ComalaI18nBean i18nBean;
    private final List<Long> pageIds;
    private final DarkFeatureManager darkFeatureManager;

    public AttachActivityTask(String spaceKey, AttachActivityTaskRecord attachActivityTaskRecord, DefaultCloudMigrationContentService defaultCloudMigrationContentService, ReadWriteTransactionService readWriteTransactionService, ComalaI18nBean i18nBean, List<Long> pageIds, DarkFeatureManager darkFeatureManager) {
        this.spaceKey = spaceKey;
        this.attachActivityTaskRecord = attachActivityTaskRecord;
        this.defaultCloudMigrationContentService = defaultCloudMigrationContentService;
        this.readWriteTransactionService = readWriteTransactionService;
        this.i18nBean = i18nBean;
        this.pageIds = pageIds;
        this.darkFeatureManager = darkFeatureManager;
    }

    protected void runInternal() {
        try {
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("Starting long running task to attach activity csv to pages in space: {}", (Object)this.spaceKey);
                }
                this.attachActivityTaskRecord.setStartedTimestamp(new Date().getTime());
                if (this.pageIds != null && !this.pageIds.isEmpty()) {
                    this.attachActivityTaskRecord.setStatus(AttachActivityTaskStatus.IN_PROGRESS);
                    this.defaultCloudMigrationContentService.setStatus(this.spaceKey, this.attachActivityTaskRecord);
                    if (log.isDebugEnabled()) {
                        log.debug("Long running task set to IN PROGRESS for space: {}", (Object)this.spaceKey);
                    }
                    AtomicLong pagesProcessed = new AtomicLong(0L);
                    this.progress.setCurrentCount(0);
                    this.progress.setTotalObjects(this.pageIds.size());
                    try {
                        this.generateFiles(this.pageIds, pagesProcessed);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.saveActivityTaskStatus(AttachActivityTaskStatus.COMPLETED, new Date().getTime());
                    this.progress.setCompletedSuccessfully(true);
                    if (log.isDebugEnabled()) {
                        log.debug("Long running task set to COMPLETED for space: {}", (Object)this.spaceKey);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("No pages to process, setting long running task to COMPLETED for space: {}", (Object)this.spaceKey);
                    }
                    this.saveActivityTaskStatus(AttachActivityTaskStatus.COMPLETED, new Date().getTime());
                    this.progress.setCompletedSuccessfully(true);
                }
                return null;
            });
        }
        catch (Exception e) {
            this.saveActivityTaskStatus(AttachActivityTaskStatus.FAIL, new Date().getTime());
            this.progress.setCompletedSuccessfully(false);
            log.error("Error processing pages to attach activity as csv", (Throwable)e);
        }
        finally {
            this.finishProcess(this.pageIds);
        }
    }

    private void finishProcess(List<Long> pageIds) {
        this.progress.setPercentage(100);
        this.progress.setCurrentCount(pageIds.size());
    }

    private void saveActivityTaskStatus(AttachActivityTaskStatus attachActivityTaskStatus, long time) {
        this.attachActivityTaskRecord.setEndedTimestamp(time);
        this.attachActivityTaskRecord.setStatus(attachActivityTaskStatus);
        this.defaultCloudMigrationContentService.setStatus(this.spaceKey, this.attachActivityTaskRecord);
    }

    private void generateFiles(List<Long> pageIds, AtomicLong pagesProcessed) throws Exception {
        if (this.darkFeatureManager.isEnabledForAllUsers("com.comalatech.workflow.attach.activity.task.zip").orElse(false).booleanValue()) {
            this.attachCSVPerSpace(pageIds);
        } else {
            this.attachCSVPerPage(pageIds, pagesProcessed);
        }
    }

    private void attachCSVPerSpace(List<Long> pageIds) throws Exception {
        HashMap<Long, String> pageCsvFileList = new HashMap<Long, String>();
        pageIds.forEach(pageId -> {
            try {
                this.progress.setStatus(this.i18nBean.getText("awp.space.attachActivity.progress.status", new Object[]{String.valueOf(pageId)}));
                pageCsvFileList.put((Long)pageId, this.defaultCloudMigrationContentService.getPageCsv((Long)pageId));
            }
            catch (Exception e) {
                log.error("Error creating the csv to the page: {}", pageId);
                throw e;
            }
        });
        try {
            this.defaultCloudMigrationContentService.attachZipToHomePage(this.spaceKey, pageCsvFileList);
        }
        catch (Exception e) {
            log.error("Error creating the zip to the home page: {}", (Object)e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    private void attachCSVPerPage(List<Long> pageIds, AtomicLong pagesProcessed) {
        pageIds.forEach(pageId -> {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Attaching activity to page: {}", pageId);
                }
                this.progress.setStatus(this.i18nBean.getText("awp.space.attachActivity.progress.status", new Object[]{String.valueOf(pageId)}));
                this.defaultCloudMigrationContentService.attachCsvToPage((long)pageId);
            }
            catch (Exception e) {
                log.error("Error attaching the csv to the page: {}", pageId);
                throw e;
            }
            pagesProcessed.addAndGet(1L);
            this.progress.setPercentage(pagesProcessed.intValue(), pageIds.size());
        });
    }

    public String getName() {
        return this.i18nBean.getText("awp.space.attachActivity.task.name");
    }
}

