/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.accessor.CloudMigrationAccessor;
import com.comalatech.confluence.util.db.DataBaseNameUtil;
import com.comalatech.confluence.util.db.SqlQueryBuilder;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.persistence.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultCloudMigrationAccessor
implements CloudMigrationAccessor {
    public final EntityManagerProvider entityManagerProvider;

    public DefaultCloudMigrationAccessor(@ComponentImport EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public boolean isEntityAvailable(String table) {
        String result = this.makeSearch(table);
        return result != null && result.toLowerCase().contains(table.toLowerCase());
    }

    private String makeSearch(String table) {
        SqlQueryBuilder sqlQueryBuilder = new SqlQueryBuilder.Builder(DataBaseNameUtil.getDatabaseName(this.entityManagerProvider), UnaryOperator.identity()).addTable(table).build();
        String selectQuery = sqlQueryBuilder.existTableQuery();
        Query query = this.entityManagerProvider.getEntityManager().createNativeQuery(selectQuery);
        List result = query.getResultList();
        if (result != null && !result.isEmpty()) {
            return (String)result.get(0);
        }
        return null;
    }
}

