/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="User related information")
public class User {
    private static final int MAX_NAME_LENGTH = 30;
    @ApiModelProperty(value="User name", dataType="string", example="user_1")
    String name;
    @ApiModelProperty(value="Role name", dataType="string", example="Project Manager")
    String rolename;
    @ApiModelProperty(value="Users' short name", dataType="string", example="user_1")
    String shortName;
    @ApiModelProperty(value="Users' full name", dataType="string", example="User One")
    String fullName;
    @ApiModelProperty(value="ink to the user's avatar", dataType="string", example="/images/icons/profilepics/user1.png")
    String pictureUrl;

    public User() {
    }

    public User(String name, String rolename, String fullName, String pictureUrl) {
        this.name = name;
        this.rolename = rolename;
        this.fullName = fullName;
        this.pictureUrl = pictureUrl;
        this.shortName = fullName.length() > 30 ? fullName.substring(0, 30) + "..." : fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getRolename() {
        return this.rolename;
    }

    public void setRolename(String rolename) {
        this.rolename = rolename;
    }

    public String toString() {
        return "User [name=" + this.name + ", rolename=" + this.rolename + ", shortName=" + this.shortName + ", fullName=" + this.fullName + ", pictureUrl=" + this.pictureUrl + "]";
    }
}

