/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class MapOfListXMLAdapter
extends XmlAdapter<ListOfEntry, Map<String, List>> {
    public Map unmarshal(ListOfEntry loe) throws Exception {
        HashMap<String, List> map = new HashMap<String, List>();
        for (Entry entry : loe.list) {
            map.put(entry.key, entry.list);
        }
        return map;
    }

    public ListOfEntry marshal(Map<String, List> map) throws Exception {
        return new ListOfEntry(map.entrySet().stream().map(entry -> new Entry((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList()));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Entry {
        @XmlElement
        public String key;
        @XmlElement
        public List list = new ArrayList();

        public Entry() {
        }

        public Entry(String key, List list) {
            this.key = key;
            this.list = list;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ListOfEntry {
        @XmlElement
        public List<Entry> list;

        public ListOfEntry() {
        }

        public ListOfEntry(List<Entry> list) {
            this.list = list;
        }
    }
}

