/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function (AJS, $) {
    AJS.toInit(function () {
        if (AJS.params.deletePageVersionsForbidden ) {
            $(".remove-historical-version-trigger").each(function () {
                // Removes the text node before checking is a real text node (nodeType is standard but Node do not exist in IE7)
                var textBefore = this.previousSibling;
                if (textBefore && textBefore.nodeType && textBefore.nodeType === 3 /*Node.TEXT_NODE*/) {
                    $(textBefore).remove();
                }
                $(this).remove();
            });
        }
    });
})(AJS, AJS.$);