AJS.toInit(function ($) {
    var URL_DEV = 'http://localhost:3000', // For local testing
        URL_PROD = 'https://analytics.comalatech.io/1/app-stats',
        MAX_RETRIES_BEFORE_ACK = 5,
        stats = {},
        comalatechToken,
        pluginKey = '${pluginKey}', // Replaced in transformer
        prefix = pluginKey.replace('-', ''), // Slashes not supported in AJS-metas
        trace = AJS.params[prefix + 'Trace'],
        devMode = !!AJS.params[prefix + 'DevMode'],
        prefixLength = (prefix + 'Stats').length,
        ack = function () {
            $.ajax({
                type: 'POST',
                url: AJS.Confluence.getContextPath() + '/rest/' + pluginKey + '/analytics/1/analytics/ack',
                headers: {'x-atlassian-token': 'no-check'},
                success: function () {
                    trace && console.log('🔔🔔🔔 Acked stats');
                }
            });
        };

    Object.keys(AJS.params)
        .filter(function (key) {
            return key.startsWith(prefix + 'Stats');
        })
        .forEach(function (key) {
            var index = key.substring(prefixLength);
            index = index.charAt(0).toLowerCase() + index.slice(1);
            if (typeof AJS.params[key] === 'boolean') {
                stats[index] = AJS.params[key];
            } else {
                stats[index] = isNaN(AJS.params[key]) ? AJS.params[key] : +AJS.params[key]
            }
        });

    // Check mandatory fields
    if (stats['instanceId'] && stats['timestamp'] && stats['comalatechToken']) {
        comalatechToken = stats['comalatechToken'];
        delete stats['comalatechToken'];
        $.ajax({
            type: 'POST',
            url: (devMode ? URL_DEV : URL_PROD) + "?token=" + encodeURIComponent(comalatechToken),
            cache: false,
            contentType: "text/plain; charset=utf-8",
            data: JSON.stringify(stats),
            success: function () {
                trace && console.log('🔔🔔🔔 Sent stats!!!!', devMode && 'DEV MODE', stats);
                sessionStorage.removeItem('retries');
                ack();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                trace && console.error('🔕🔕🔕 Error sending stats', textStatus, errorThrown);
                var retries = parseInt(sessionStorage.getItem('retries') || 0);
                if (retries >= MAX_RETRIES_BEFORE_ACK) {
                    trace && console.error('🔕🔕🔕 Max retries reached... ack-ing anyway');
                    ack();
                } else {
                    sessionStorage.setItem('retries', retries + 1);
                }
            }
        });
    }
});