/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.BaseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.randombits.storage.Aliasable;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringBasedStorage
extends BasedStorage
implements Aliasable {
    private static final Logger LOG = Logger.getLogger(StringBasedStorage.class);
    private XStream xStream;

    public StringBasedStorage(BasedStorage.BoxType type) {
        super(type);
    }

    @Override
    public void addAlias(String alias, Class<?> clazz) {
        this.getXStream().alias(alias, clazz);
    }

    private XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = new XStream();
            this.xStream.setClassLoader(this.getClass().getClassLoader());
        }
        return this.xStream;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.getXStream().setClassLoader(classLoader);
    }

    protected String objectToXML(Object value) {
        if (value != null) {
            return this.getXStream().toXML(value);
        }
        return null;
    }

    protected Object xmlToObject(String xml) {
        if (xml != null) {
            try {
                return this.getXStream().fromXML(xml);
            }
            catch (BaseException e) {
                LOG.debug((Object)"Conversion error occurred while retrieving object.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected Boolean getBaseBoolean(String name) {
        String value = this.getBaseString(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    @Override
    protected Date getBaseDate(String name) {
        Long time = this.getBaseLong(name);
        if (time != null) {
            return new Date(time);
        }
        return null;
    }

    @Override
    protected Double getBaseDouble(String name) {
        String value = this.getBaseString(name);
        try {
            if (this.notEmpty(value)) {
                return new Double(value);
            }
        }
        catch (NumberFormatException e) {
            throw new StorageException("Value for '" + name + "' is not a valid double: " + value, e);
        }
        return null;
    }

    @Override
    protected Integer getBaseInteger(String name) {
        Number n = this.getBaseNumber(name);
        return null == n ? null : new Integer(n.intValue());
    }

    private boolean notEmpty(String value) {
        return value != null && value.trim().length() > 0;
    }

    @Override
    protected Long getBaseLong(String name) {
        Number n = this.getBaseNumber(name);
        return null == n ? null : new Long(n.longValue());
    }

    @Override
    protected Number getBaseNumber(String name) {
        return this.getBaseDouble(name);
    }

    protected <T> T getBaseObject(String name, Class<T> clazz) {
        Object value = this.getBaseObject(name);
        return this.toType(value, null, clazz);
    }

    @Override
    protected Object getBaseObject(String name) {
        String value = this.getBaseString(name);
        if (value != null) {
            Object obj = this.xmlToObject(value);
            return obj == null ? value : obj;
        }
        return null;
    }

    @Override
    protected List<?> getBaseObjectList(String name) {
        String[] values = this.getBaseStringArray(name);
        if (values != null && values.length >= 0) {
            ArrayList<Object> list = new ArrayList<Object>(values.length);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].trim().length() == 0) {
                    list.add(null);
                    continue;
                }
                list.add(this.xmlToObject(values[i]));
            }
            return list;
        }
        return null;
    }

    @Override
    protected String[] getBaseStringArray(String name) {
        String fieldSizeName = name + ".length";
        Integer fieldSize = this.getBaseInteger(fieldSizeName);
        if (fieldSize != null && fieldSize >= 0) {
            String[] value = new String[fieldSize.intValue()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = this.getBaseString(name + "." + i);
            }
            return value;
        }
        return null;
    }

    @Override
    protected void setBaseBoolean(String name, Boolean value) {
        if (value != null) {
            this.setBaseString(name, value.toString());
        } else {
            this.setBaseString(name, null);
        }
    }

    @Override
    protected void setBaseDate(String name, Date value) {
        if (value != null) {
            this.setBaseLong(name, new Long(value.getTime()));
        } else {
            this.setBaseString(name, null);
        }
    }

    @Override
    protected void setBaseDouble(String name, Double value) {
        if (value != null) {
            this.setBaseString(name, value.toString());
        } else {
            this.setBaseString(name, null);
        }
    }

    @Override
    protected void setBaseInteger(String name, Integer value) {
        if (value != null) {
            this.setBaseString(name, value.toString());
        } else {
            this.setBaseString(name, null);
        }
    }

    @Override
    protected void setBaseLong(String name, Long value) {
        if (value != null) {
            this.setBaseString(name, value.toString());
        } else {
            this.setBaseString(name, null);
        }
    }

    @Override
    protected void setBaseObject(String name, Object value) {
        if (value != null) {
            this.setBaseString(name, this.objectToXML(value));
        } else {
            this.setBaseString(name, null);
        }
    }

    @Override
    protected void setBaseObjectList(String name, List<?> value) {
        int i;
        String fieldLengthName = name + ".length";
        Integer oldLength = this.getBaseInteger(fieldLengthName);
        if (oldLength != null) {
            for (i = 0; i < oldLength; ++i) {
                this.setBaseObject(name + "." + i, null);
            }
        }
        if (value == null) {
            this.setBaseInteger(fieldLengthName, null);
        } else {
            this.setBaseInteger(fieldLengthName, new Integer(value.size()));
            for (i = 0; i < value.size(); ++i) {
                this.setBaseObject(name + "." + i, value.get(i));
            }
        }
    }

    @Override
    protected void setBaseStringArray(String name, String[] value) {
        String fieldLengthName = name + ".length";
        Integer oldLength = this.getBaseInteger(fieldLengthName);
        if (oldLength != null) {
            int oli = oldLength;
            for (int i = 0; i < oli; ++i) {
                this.setBaseString(name + "." + i, null);
            }
        }
        if (value == null) {
            this.setBaseInteger(fieldLengthName, null);
        } else {
            this.setBaseInteger(fieldLengthName, new Integer(value.length));
            for (int i = 0; i < value.length; ++i) {
                this.setBaseString(name + "." + i, value[i]);
            }
        }
    }
}

