/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.randombits.confluence.filtering.param.Parameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.support.MacroInfo;
import org.randombits.storage.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParameter<T>
implements Parameter<T> {
    private List<String> paramNames;
    private String defaultValue;

    public BaseParameter(String defaultValue, String ... names) {
        this.paramNames = new ArrayList<String>(Arrays.asList(names));
        this.defaultValue = defaultValue;
    }

    public BaseParameter(String defaultValue, List<String> names) {
        this.paramNames = new ArrayList<String>(names);
        this.defaultValue = defaultValue;
    }

    public void addParameterAlias(String name) {
        this.paramNames.add(name);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected String getParameter(Storage params, List<String> names, String defaultValue) {
        String param;
        String value = null;
        Iterator<String> i$ = names.iterator();
        while (i$.hasNext() && (value = params.getString(param = i$.next(), null)) == null) {
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public T findValue(MacroInfo info) throws ParameterException {
        String paramValue = this.getParameter(info.getMacroParams(), this.paramNames, this.defaultValue);
        return this.findObject(paramValue, info);
    }

    protected abstract T findObject(String var1, MacroInfo var2) throws ParameterException;
}

