/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflows.lite.rest.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.DefaultWorkflowService;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestWorkflowParam;
import com.comalatech.confluence.workflow.rest.model.RestWorkflowParamTranslator;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestSpaceSettings;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.model.WorkflowParameter;
import com.comalatech.workflow.model.WorkflowParameterType;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/space")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"ADMINISTER"})
public class WorkflowsLiteSpaceAdminResource
extends AbstractRestResource {
    private final String DUE_DATE_WORKFLOW_PARAMETER = "Due Date";
    private final String QMS_USERS_WORKFLOW_PARAMETER = "Users";
    private final String QMS_GROUPS_WORKFLOW_PARAMETER = "Groups";
    private final String QMS_READ_ACK_QMS_GROUPS_WORKFLOW_PARAMETER = "ReadConfirmationGroups";
    private final String QMS_READ_ACK_QMS_USERS_WORKFLOW_PARAMETER = "ReadConfirmationUsers";
    private final WorkflowService workflowService;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final ComalaI18nBean comalaI18nBean;
    private String defaultWorkflowHandle;
    private String simpleWorkflowHandle;
    private String qmsWorkflowHandle;
    private String expiryWorkflowHandle;

    public WorkflowsLiteSpaceAdminResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, WorkflowService workflowService, InternalWorkflowParameterManager workflowParameterManager, WorkflowContainerManager workflowContainerManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.workflowService = workflowService;
        this.workflowParameterManager = workflowParameterManager;
        this.comalaI18nBean = comalaI18nBean;
        try {
            Workflow simpleWorkflow = workflowMarkupManager.parseFromWikiMarkup(workflowContainerManager.loadSystemWorkflow("workflows_lite/sample.simple.workflow"));
            this.simpleWorkflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, simpleWorkflow);
            this.defaultWorkflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, simpleWorkflow);
            Workflow qmsWorkflow = workflowMarkupManager.parseFromWikiMarkup(workflowContainerManager.loadSystemWorkflow("workflows_lite/sample.qms.workflow"));
            this.qmsWorkflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, qmsWorkflow);
            Workflow expiryWorkflow = workflowMarkupManager.parseFromWikiMarkup(workflowContainerManager.loadSystemWorkflow("workflows_lite/sample.expiry.workflow"));
            this.expiryWorkflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, expiryWorkflow);
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
    }

    @GET
    @Path(value="/{spaceKey}/settings")
    @TypeHint(value=RestSpaceSettings.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Space settingss."), @ResponseCode(code=400, condition="Invalid workflow parameter.")})
    public Response getSpaceLiteSettings(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                com.comalatech.workflow.model.Workflow selectedWorkflow = WorkflowsLiteSpaceAdminResource.this.getCurrentlySelectedLiteWorkflowInSpace(spaceKey);
                if (selectedWorkflow == null) {
                    return WorkflowsLiteSpaceAdminResource.this.selectActiveWorkflow(spaceKey, WorkflowsLiteSpaceAdminResource.this.defaultWorkflowHandle);
                }
                String workflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, selectedWorkflow);
                RestSpaceSettings spaceSettings = new RestSpaceSettings(selectedWorkflow.isActive(), selectedWorkflow.getName(), StringUtils.join(selectedWorkflow.getStateNames(), (String)","), selectedWorkflow.getDescription());
                spaceSettings.handle = workflowHandle;
                List<WorkflowParameter> workflowParameters = WorkflowsLiteSpaceAdminResource.this.workflowParameterManager.getSpaceWorkflowsParameters(spaceKey, true);
                ArrayList<RestWorkflowParam> restWorkflowParams = new ArrayList<RestWorkflowParam>();
                for (WorkflowParameter workflowParameter : workflowParameters) {
                    RestWorkflowParam restWorkflowParam;
                    if (workflowHandle.equals(WorkflowsLiteSpaceAdminResource.this.simpleWorkflowHandle)) continue;
                    if (workflowHandle.equals(WorkflowsLiteSpaceAdminResource.this.qmsWorkflowHandle)) {
                        if (!workflowParameter.getName().equals("Users") && !workflowParameter.getName().equals("Groups") && !workflowParameter.getName().equals("ReadConfirmationGroups") && !workflowParameter.getName().equals("ReadConfirmationUsers")) continue;
                        restWorkflowParam = RestWorkflowParamTranslator.toRest(workflowParameter);
                        restWorkflowParam.setLabel(WorkflowsLiteSpaceAdminResource.this.comalaI18nBean.getText("workflows.lite.qms.parameter." + workflowParameter.getName()));
                        restWorkflowParam.setDescription(WorkflowsLiteSpaceAdminResource.this.comalaI18nBean.getText("workflows.lite.qms.parameter." + workflowParameter.getName() + ".description"));
                        restWorkflowParams.add(restWorkflowParam);
                        continue;
                    }
                    if (workflowHandle.equals(WorkflowsLiteSpaceAdminResource.this.expiryWorkflowHandle)) {
                        if (!workflowParameter.getName().equals("Due Date")) continue;
                        restWorkflowParam = RestWorkflowParamTranslator.toRest(workflowParameter);
                        restWorkflowParam.setLabel(WorkflowsLiteSpaceAdminResource.this.comalaI18nBean.getText("workflows.lite.expiry.parameter.DueDate"));
                        restWorkflowParam.setDescription(WorkflowsLiteSpaceAdminResource.this.comalaI18nBean.getText("workflows.lite.expiry.parameter.DueDate.description"));
                        restWorkflowParams.add(restWorkflowParam);
                        continue;
                    }
                    Message message = new Message();
                    message.type = "Error";
                    message.closeable = true;
                    message.title = "Can not get workflows settings";
                    message.html = "Invalid workflow";
                    spaceSettings.messages = Collections.singletonList(message);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceSettings).build();
                }
                spaceSettings.spaceParams = restWorkflowParams;
                return Response.ok().entity((Object)spaceSettings).build();
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/select/{workflowHandle}")
    @TypeHint(value=RestSpaceSettings.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Space settingss."), @ResponseCode(code=400, condition="Unable to copy workflow template.")})
    public Response selectActiveWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowHandle") String newWorkflowHandle) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                com.comalatech.workflow.model.Workflow selectedWorkflow = WorkflowsLiteSpaceAdminResource.this.getCurrentlySelectedLiteWorkflowInSpace(spaceKey);
                if (selectedWorkflow != null) {
                    String oldWorkflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, selectedWorkflow);
                    WorkflowsLiteSpaceAdminResource.this.workflowService.deleteWorkflow(spaceKey, oldWorkflowHandle);
                    List<WorkflowParameter> spaceParameters = WorkflowsLiteSpaceAdminResource.this.workflowParameterManager.getSpaceWorkflowsParameters(spaceKey);
                    for (WorkflowParameter param : spaceParameters) {
                        WorkflowsLiteSpaceAdminResource.this.workflowParameterManager.unRegisterWorkflowParameter(spaceKey, param);
                    }
                }
                try {
                    WorkflowsLiteSpaceAdminResource.this.workflowService.copyWorkflowToSpace(spaceKey, newWorkflowHandle, false);
                    com.comalatech.workflow.model.Workflow copiedWorkflow = WorkflowsLiteSpaceAdminResource.this.getCurrentlySelectedLiteWorkflowInSpace(spaceKey);
                    if (copiedWorkflow != null) {
                        String copiedWorkflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, copiedWorkflow);
                        if (copiedWorkflowHandle.equals(newWorkflowHandle)) {
                            return WorkflowsLiteSpaceAdminResource.this.getSpaceLiteSettings(spaceKey);
                        }
                        throw new WorkflowException("Selected space workflow was not the expected one");
                    }
                    throw new WorkflowException("Selected workflow was not set");
                }
                catch (WorkflowException ex) {
                    return WorkflowsLiteSpaceAdminResource.this.handleException(ex);
                }
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/enable")
    @TypeHint(value=RestSpaceSettings.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Space settingss."), @ResponseCode(code=400, condition="Could not enable workflow.")})
    public Response enableLiteWorkflow(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    com.comalatech.workflow.model.Workflow selectedWorkflow = WorkflowsLiteSpaceAdminResource.this.getCurrentlySelectedLiteWorkflowInSpace(spaceKey);
                    if (selectedWorkflow == null) {
                        return Response.noContent().build();
                    }
                    String workflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, selectedWorkflow);
                    WorkflowsLiteSpaceAdminResource.this.workflowService.activateWorkflow(spaceKey, workflowHandle);
                    return WorkflowsLiteSpaceAdminResource.this.getSpaceLiteSettings(spaceKey);
                }
                catch (WorkflowException ex) {
                    return WorkflowsLiteSpaceAdminResource.this.handleException(ex);
                }
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/disable")
    @TypeHint(value=RestSpaceSettings.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Space settingss."), @ResponseCode(code=400, condition="Could not disable workflow.")})
    public Response disableCurrentWorkflow(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                com.comalatech.workflow.model.Workflow selectedWorkflow = WorkflowsLiteSpaceAdminResource.this.getCurrentlySelectedLiteWorkflowInSpace(spaceKey);
                if (selectedWorkflow == null) {
                    return Response.noContent().build();
                }
                String workflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, selectedWorkflow);
                WorkflowsLiteSpaceAdminResource.this.workflowService.deactivateWorkflow(spaceKey, workflowHandle);
                return WorkflowsLiteSpaceAdminResource.this.getSpaceLiteSettings(spaceKey);
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/params")
    @TypeHint(value=RestSpaceSettings.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Space settings."), @ResponseCode(code=400, condition="Unable to store workflow parameters")})
    public Response setSpaceParameters(final @PathParam(value="spaceKey") String spaceKey, final List<RestWorkflowParam> restWorkflowParams) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    com.comalatech.workflow.model.Workflow selectedWorkflow = WorkflowsLiteSpaceAdminResource.this.getCurrentlySelectedLiteWorkflowInSpace(spaceKey);
                    boolean allParamEmpty = true;
                    for (RestWorkflowParam param : restWorkflowParams) {
                        if ((param.getValue() == null || param.getValue().isEmpty()) && (param.getType() != WorkflowParameterType.DURATION || !StringUtils.isNotBlank((CharSequence)param.getValue()))) continue;
                        allParamEmpty = false;
                    }
                    if (!allParamEmpty) {
                        for (RestWorkflowParam param : restWorkflowParams) {
                            WorkflowsLiteSpaceAdminResource.this.workflowParameterManager.setSpaceWorkflowParameter(spaceKey, RestWorkflowParamTranslator.toModel(param));
                        }
                    } else if (selectedWorkflow.isActive()) {
                        throw new WorkflowException("Can not set empty parameters in an active workflow");
                    }
                    return WorkflowsLiteSpaceAdminResource.this.getSpaceLiteSettings(spaceKey);
                }
                catch (com.comalatech.workflow.WorkflowException ex) {
                    return WorkflowsLiteSpaceAdminResource.this.handleException(ex);
                }
            }
        }.execute();
    }

    private com.comalatech.workflow.model.Workflow getCurrentlySelectedLiteWorkflowInSpace(String spaceKey) {
        List<com.comalatech.workflow.model.Workflow> spaceWorkflows = this.workflowService.getWorkflows(spaceKey);
        for (com.comalatech.workflow.model.Workflow workflow : spaceWorkflows) {
            String workflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, workflow);
            if (!workflowHandle.equals(this.simpleWorkflowHandle) && !workflowHandle.equals(this.qmsWorkflowHandle) && !workflowHandle.equals(this.expiryWorkflowHandle)) continue;
            return workflow;
        }
        return null;
    }
}

